% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HRTList.R
\name{getHRTParams}
\alias{getHRTParams}
\alias{getHRTParams,HRTList-method}
\title{Extracts all values of a special slot out of a HRTList}
\usage{
getHRTParams(HRTListObj, sl)

\S4method{getHRTParams}{HRTList}(HRTListObj, sl)
}
\arguments{
\item{HRTListObj}{HRTList object}

\item{sl}{(Character) Value of a slot saved by an HRT object}
}
\value{
(numeric vector or list) Vector or list of the numerics stored in the given slot
}
\description{
Extracts all values of the given slot in each HRT of the HRTList
and returns them in a list
}
\examples{
# You need an HRTList
hrtl <- vectorToHRT(testdataLong, testdataLong_Ann)

# Get all TOs of the HRTs in your HRTList
getHRTParams(hrtl, "TO")

# You can access all slots in the HRTs
getHRTParams(hrtl, "intercept")

# If you access slots that include more than one numeric, the function returns a list
getHRTParams(hrtl, "preRRs")

}
