% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dense_matrix_kernels.R
\name{QrMicrobenchmark}
\alias{QrMicrobenchmark}
\title{Conducts a single performance trial with the QR factorization dense matrix
kernel}
\usage{
QrMicrobenchmark(benchmarkParameters, kernelParameters)
}
\arguments{
\item{benchmarkParameters}{an object of type
\code{\link{DenseMatrixMicrobenchmark}} specifying various parameters
for microbenchmarking the dense matrix kernel}

\item{kernelParameters}{a list of matrices or vectors to be used as input to
the dense matrix kernel}
}
\description{
\code{QrMicrobenchmark} conducts a single performance trial of the
QR factorization dense matrix kernel for the matrix given in the
\code{kernelParameters} parameter.  The function times the single function
call \code{qr(kernelParameters$A, LAPACK=TRUE)}.
}
\examples{
\dontrun{
# Allocate input to the QR decomposition microbenchmark for the
# first matrix size to be tested
microbenchmarks <- GetDenseMatrixDefaultMicrobenchmarks()
kernelParameters <- QrAllocator(microbenchmarks[["qr"]], 1)
# Execute the microbenchmark
timings <- QrMicrobenchmark(microbenchmarks[["qr"]], kernelParameters)
}

}
