% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{ClusteringMicrobenchmark}
\alias{ClusteringMicrobenchmark}
\title{This class specifies a clustering for machine learning microbenchmark.}
\description{
This class specifies a clustering for machine learning microbenchmark.
}
\section{Fields}{

\describe{
\item{\code{active}}{a logical indicating whether the microbenchmark is to be
executed (TRUE) or not (FALSE).}

\item{\code{benchmarkName}}{a character string that is the name of the
microbenchmark.}

\item{\code{benchmarkDescription}}{a character string describing the microbenchmark.}

\item{\code{dataObjectName}}{a character string specifying the name of the data
object that is input to the benchmark; the object must be stored in
the R data file with the same base name and a \code{.RData} extension.
Setting the field to \code{NA_character_} indicates that the test data will
be dynamically generated by the function given in the
\code{allocatorFunction} field instead of read from a data file.}

\item{\code{numberOfFeatures}}{the number features; this value must match the
number of features in the data set given by the field \code{dataObjectName}
unless the field is populated with \code{NA_character_}.}

\item{\code{numberOfClusters}}{the number of clusters in the data set; this value
must match the number of clusters in the data set given by the field
\code{dataObjectName} unless the field is populated with
\code{NA_character_}.}

\item{\code{numberOfFeatureVectorsPerCluster}}{the number of feature vectors per
cluster; this value must match the number of clusters in the data set given
by the field \code{dataObjectName} unless the field is populated with
\code{NA_character_}.}

\item{\code{numberOfTrials}}{an integer specifying the number of performance
trials conducted on the data set to be tested.}

\item{\code{numberOfWarmupTrials}}{an integer specifying the number of warmup
trials to be conducted on the data set.}

\item{\code{allocatorFunction}}{the function that allocates and initializes input
to the benchmark function.  The function takes a
\code{ClusteringMicrobenchmark} object.  For clustering benchmarks, the
allocator function should return a list containing the following items:
\describe{
  \item{featureVectors}{a matrix, the rows of which are the feature
    vectors}
  \item{numberOfFeatures}{an integer indicating the number of features}
  \item{numberOfFeatureVectors}{an integer indicating the number of feature
    vectors}
  \item{numberOfClusters}{an integer indicating the number of clusters in
    the data set}
}}

\item{\code{benchmarkFunction}}{the benchmark function which executes the
functionality to be timed.  The function takes a
\code{SparseMatrixMicrobenchmark} and a list of kernel parameters
returned by the allocator function.}
}}

