% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateGremlinsModelHelperFunctions.R
\name{convert_to_bayesm}
\alias{convert_to_bayesm}
\title{Convert 'RGremlinsConjoint' formatted Data to 'bayesm' format}
\usage{
convert_to_bayesm(data, design)
}
\arguments{
\item{data}{The data.frame or matrix that contains the respondents answers}

\item{design}{The data.frame or matrix that contains the coded design}
}
\value{
lgtdata The list data structure for use with 'bayesm'
}
\description{
Converts a data file and a coded design file from the format expected by the
package to a format appropriate for estimation in 'bayesm'
\code{\link[bayesm]{rhierMnlRwMixture}}
}
\examples{
\dontrun{
 data <- read.csv("data.csv")
 design <- read.csv("design.csv")
 design <- code_sawtooth_design(design)
 convert_to_bayesm(data, design)
}
}
\seealso{
\code{\link{code_sawtooth_design}}
}
