% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_marginal_distributions.R
\name{export_marginal_distributions}
\alias{export_marginal_distributions}
\title{Export Marginal Distributions}
\usage{
export_marginal_distributions(
  marginals,
  folder_path,
  create_folder = FALSE,
  force = FALSE
)
}
\arguments{
\item{marginals}{an Object of type RESIDE from
\code{\link{import_cor_matrix}}}

\item{folder_path}{path to folder where to save files.}

\item{create_folder}{if the folder does not exist should it be created,
Default: FALSE}

\item{force}{if the folder already contains marginal distribution files
should they be removed, Default: FALSE}
}
\value{
No return value, called for exportation of files.
}
\description{
Export the marginal distributions to CSV files
}
\details{
Exports each of the marginal distributions to CSV files
within a given folder, along with the continuous quantiles.
}
\examples{
\donttest{
  marginal_distributions <- get_marginal_distributions(IST)
  export_marginal_distributions(
    marginal_distributions,
    folder_path = tempdir()
  )
}
}
\seealso{
\code{\link{get_marginal_distributions}}
}
