% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{validate_input}
\alias{validate_input}
\title{Validate Input Data for Hedonic Index Calculation}
\usage{
validate_input(
  dataset,
  period_variable,
  dependent_variable,
  numerical_variables,
  categorical_variables,
  reference_period = NULL
)
}
\arguments{
\item{dataset}{A data.frame containing the dataset to be validated.}

\item{period_variable}{A string specifying the name of the period variable column.}

\item{dependent_variable}{A string specifying the name of the dependent variable (usually the sale price).}

\item{numerical_variables}{A character vector with names of numeric quality-determining variables.}

\item{categorical_variables}{A character vector with names of categorical variables (including dummies).}

\item{reference_period}{Optional string for the base period to normalize index values (e.g., "2015", "2020Q1").}
}
\description{
This function checks whether the dataset contains all required variables, whether the dependent and numerical variables are numeric,
and whether the period variable is formatted correctly (e.g., "2020Q1", "2020M01", or just "2015").
It also performs soft-matching to adjust a provided reference_period to align with the dataset.
}
\author{
David Pietersz, Vivek Gajadhar
}
\keyword{internal}
