% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatting-functions.R
\name{format_data}
\alias{format_data}
\title{Format the dataset to the syntax of REDI functions}
\usage{
format_data(
  data,
  input = 1,
  output = 2,
  by = "day",
  format = "\%Y\%m\%d",
  summary_duplicate = mean
)
}
\arguments{
\item{data}{A tibble or data frame containing one column indicating time and
another indicating the quantity for which we want to compute REDI.}

\item{input}{A character or a number, indicating whether the name or the
index of the input column (time).}

\item{output}{A character or a number, indicating whether the name or the
index of the output column (workload).}

\item{by}{A number or a character string, indicating the reference time
period between two observations. Possible values are 'day', 'week',
'month', 'year', or any arbitrary number. See documentation of the 'seq()'
for additional information if necessary. Default is 'day'.}

\item{format}{A character string, indicating the date format of the input.
Please read \code{lubridate::as_date()}. Default is '\%Y\%m\%d'.}

\item{summary_duplicate}{A function, used to summarise Output values for
duplicated Input values. Default is mean.}
}
\value{
A tibble with Input and Output columns and explicit missing values
between observations.
}
\description{
Format the dataset to the syntax of REDI functions
}
\examples{
TRUE
}
