% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlateC.r
\name{correlateC}
\alias{correlateC}
\title{Correlation analysis for two or more numeric variables, with options for scatterplots, weighted observations, and inferential statistics.}
\usage{
correlateC(x, w, data, digits = 3, stats = FALSE, printC = FALSE,
  plot = FALSE, jitter = FALSE, ...)
}
\arguments{
\item{x}{A list of variables for correlation analysis, variables must be numeric. Should be entered as list(dataset$var1, dataset$var2, dataset$var3 ... ) form unless dataset specified in optional data argument.}

\item{w}{(Optional) Sampling weights variable, must be numeric; should be in dataset$weightvar form unless dataset specified in optional data argument.}

\item{data}{(Optional) Name of dataset that contains x (and w) variable (optional).}

\item{digits}{(Optional) Number of decimal places reported in result (defaults to 3).}

\item{stats}{(Optional) Do you want the inferential statistics (standard errors, t-statistics, and p-values)? Default is FALSE. Set to TRUE for inferential statistics.}

\item{printC}{(Optional) Do you want results printed to .html file in your working directory? Default is FALSE. Set to TRUE to print results.}

\item{plot}{(Optional) Do you want scatterplot(s)? Default is FALSE.}

\item{jitter}{(Optional) Do you want scatterplot pointed jittered? By default, points jittered when there are more than 500 observations, but you can set this arguments to TRUE/FALSE to override the default.}

\item{...}{(Optional) Additional arguments passed to \code{weights::wtd.cor} function.}
}
\value{
Returns the coefficients of correlation among x variables; if \code{stats=TRUE}, inferential statistics returned in tables as well.
}
\description{
Given two or more numeric variables, \code{correlateC} reports correlation coefficients, along with inferential statistics (if requested), works with sampling weights. If more than two x variables are supplied, the function calculates correlation coefficients using pairwise complete observations (as opposed to limiting analysis to observations complete on all variables).
The \code{\link[weights]{wtd.cor}} function is imported from the weights package. See \code{\link[weights]{wtd.cor}} documentation for details.
}
\details{
Makes use of the wtd.cor function, part of the weights package.
}
\section{RCPA3 Package Tutorial Videos}{

\itemize{
\item \href{https://www.youtube.com/watch?v=sYBywL4t1fY}{Correlation Analysis with RCPA3's correlateC Function} 9:01
\item \href{https://www.youtube.com/playlist?list=PL3jY4WDTUxoNqrxSSQH4q7XPLPYipeNCu}{Complete Playlist of RCPA3 Package Tutorial Videos}, includes video for this function and many more.
}
}

\section{Textbook References}{

\itemize{
\item Philip H. Pollock and Barry C. Edwards, \emph{An R Companion to Political Analysis, 3rd Edition} (Thousand Oaks, CA: Sage Publications, Forthcoming 2022), Chapter 11.
\item Philip H. Pollock and Barry C. Edwards, \emph{The Essentials of Political Analysis, 6th Edition} (Thousand Oaks, CA: Sage Publications, 2020), pp. 240-244. ISBN-13: 978-1506379616; ISBN-10: 150637961.
}
}

\section{Online Resources}{

\itemize{
\item \href{https://www.poliscidata.com/pages/rDemosResources.php?chapter=11}{R Tutorials & Resources for Correlation and Bivariate Regression}, compiled by Barry C. Edwards.
\item \href{https://edge.sagepub.com/pollock}{Sage Edge Resources for Political Analysis Series}, for streaming videos, flashcards, and more student resources for textbooks by Pollock and Edwards, from Sage Publications.
\item \href{https://www.poliscidata.com}{Political Science Data Web Site}: Find datasets for your own research and resources to help with the analysis.
}
}

\examples{
   library(RCPA3)
   
   correlateC(x=list(abortlaws, women.stateleg), data=states, plot=FALSE)
   
   \dontrun{
   # with weighted observations and inferential statistics
   correlateC(x=list(nes$ft.rep, nes$ft.trump.pre, nes$ft.dem, nes$ft.biden.pre), 
              w=nes$wt, stats=TRUE)
   }
}
