% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_feature_score.r
\name{estimate_feature_score}
\alias{estimate_feature_score}
\alias{estimate_feature_score.default}
\alias{estimate_feature_score.RCNA_object}
\title{estimate_feature_score: Estimate CNV score for each gene in the annotation file}
\usage{
estimate_feature_score(obj, ...)

\method{estimate_feature_score}{default}(
  obj = NULL,
  df = NULL,
  sample.names = NULL,
  ano.file,
  out.dir = NULL,
  ncpus = 1,
  file.score.coverage = NULL,
  score.cutoff = 0.5,
  low.score.cutoff = NULL,
  high.score.cutoff = NULL,
  verbose = FALSE,
  ...
)

\method{estimate_feature_score}{RCNA_object}(obj, verbose = FALSE, ...)
}
\arguments{
\item{obj}{A RCNA_object type object - parameters will be pulled from the object instead, specifically from the `scoreParams` slot.}

\item{...}{Additional arguments (unused)}

\item{df}{Path to the config file, or a `data.frame` object containing the valid parameters. Valid column names are `file.score.coverage` and `sample.names`. Additional columns will be ignored.}

\item{sample.names}{Character vector of sample names. Alternatively can be specified in `df`.}

\item{ano.file}{Location of the annotation file. This file must be in CSV format and contain the following information (with column headers as specified): "feature,chromosome,start,end".}

\item{out.dir}{Output directory for results. A subdirectory for results will be created under this + `/nkr/`.}

\item{ncpus}{Integer number of CPUs to use. Specifying more than one allows this function to be parallelized by feature.}

\item{file.score.coverage}{Character vector listing the input coverage files. Must be the same length as `sample.names`. Alternatively can be specified in `df`.}

\item{score.cutoff}{Numeric between 0 and 1 which specifies the score filter on the results file. This parameter creates a symmetrical cutoff around 0, filtering all results whose absolute value is less than the specified value. Non-symmetrical cutoffs can be specified using `low.score.cutoff` and `high.score.cutoff`.}

\item{low.score.cutoff}{Numeric between 0 and 1 which specifies the lower score cutoff. Defaults to `score.cutoff` if not specified.}

\item{high.score.cutoff}{Numeric between 0 and 1 which specifies the upper score cutoff. Defaults to `score.cutoff` if not specified.}

\item{verbose}{If set to TRUE will display more detail}
}
\value{
A \linkS4class{RCNA_analysis} class object that describes the input parameters and output files generated by this step of the workflow.

A \linkS4class{RCNA_analysis} class object that describes the input parameters and output files generated by this step of the workflow.

A \linkS4class{RCNA_analysis} class object that describes the input parameters and output files generated by this step of the workflow.
}
\description{
This function estimates the the CNA score for each feature in the annotation file. It creates two flat file text tables with a row for each feature, which is placed in the output directory under `/score` - one with the score filter applied and one with all score results reported.

This function estimates the the CNA score for each feature in the annotation file. It creates two flat file text tables with a row for each feature, which is placed in the output directory under `/score` - one with the score filter applied and one with all score results reported.
}
\details{
This function can be run as a stand-alone or as part of \link{run_RCNA}.

The `df` argument corresponds to the `scoreParams` matrix on \linkS4class{RCNA_object}. Valid column names are `sample.names` and `file.score.coverage`. Additional columns will be ignored.

For more parameter information, see \link{estimate_feature_score.default}.
}
\examples{
## Estimate feature scores on example object
# See \link{example_obj} for more information on example
example_obj@ano.file <- system.file("examples" ,"annotations-example.csv", package = "RCNA")
\donttest{example_obj}
# Create output directories
dir.create(file.path("output", "score"), recursive = TRUE)
# Copy example GC-corrected coverage files
cov.corrected <- system.file("examples", "gc", package = "RCNA")
file.copy(from = cov.corrected, to = "output", recursive = TRUE)
# Copy example NKR results for "feature_a"
nkr.res <- system.file("examples", "nkr", package = "RCNA")
file.copy(from = nkr.res, to = "output", recursive = TRUE)
# Run score estimation for "feature_a" and append results
estimate_feature_score_analysisObj <- estimate_feature_score(example_obj)
example_obj@commands <- c(example_obj@commands, estimate_feature_score_analysisObj)
\dontshow{system("rm -rf output")}
}
\seealso{
\linkS4class{RCNA_object}, \linkS4class{RCNA_analysis}, \link{run_RCNA}
}
