% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.r
\name{create_RCNA_object}
\alias{create_RCNA_object}
\title{RCNA_object constructor}
\usage{
create_RCNA_object(
  sample.names,
  ano.file,
  ncpu = 1,
  out.dir = tempdir(),
  file.coverage = NULL,
  gcParams = NULL,
  win.size = 75,
  gc.step = 0.01,
  file.raw.coverage = NULL,
  file.corrected.coverage = NULL,
  file.gc.factor = NULL,
  estimate_gc = TRUE,
  nkrParams = NULL,
  file.nkr.coverage = NULL,
  nkr = 0.9,
  x.norm = NULL,
  norm.cov.matrix = NULL,
  scoreParams = NULL,
  file.score.coverage = NULL,
  score.cutoff = 0.5,
  low.score.cutoff = NULL,
  high.score.cutoff = NULL,
  commands = list(),
  verbose = FALSE
)
}
\arguments{
\item{sample.names}{Character vector containing names of subjects}

\item{ano.file}{Character single file path detailing a feature-wise annotation file}

\item{ncpu}{Numeric value specifying number of cores to use for analysis. Multiple cores will lead to parallel execution.}

\item{out.dir}{Character vector containing the name of each subject's output directory}

\item{file.coverage}{Character vector containing the path to the input coverage files for NKR and CNA score estimation.}

\item{gcParams}{Data Frame storing all run parameters for the correct_gc_bias function. Can be specified by a file path to a CSV file, `data.frame`, or (if not specified) will be generated by other arguments.}

\item{win.size}{Numeric value detailing the size of the sliding window used to calculate and detect correct GC-content correction.}

\item{gc.step}{Numeric value detailing the size of each GC-content bin. If providing pre-calculated GC factor file this must match the bins in that file.}

\item{file.raw.coverage}{Character vector containing the filename of the raw coverage files for GC-content correction. Must be used in combination with `estimate_gc` set to TRUE.}

\item{file.corrected.coverage}{Character vector containing the filename of the corrected coverage files.}

\item{file.gc.factor}{Character vector containing the filename of GC factor files. Used if and only if `estimate_gc` is set to FALSE.}

\item{estimate_gc}{Logical that determines if GC bias factor is calculated. If set to TRUE then GC factor files will be generated for each sample. If set to FALSE then GC factor files must be supplied via `file.gc.factor`.}

\item{nkrParams}{Data Frame storing all run parameters for the estimate_nkr function. Can be specified by a file path to a CSV file, `data.frame`, or (if not specified) will be generated by other arguments.}

\item{file.nkr.coverage}{Character vector containing the filename of the input coverage file for NKR estimation. Defaults to `file coverage` if not specified.}

\item{nkr}{Numeric between 0 and 1 which specifies the coverage quantile that should be considered a "normal" karyotype range for each position. Lowering this value may increase sensitivity but also Type I error.}

\item{x.norm}{Logical vector with length equal to the length of `sample.names`, denoting whether each subject has to be X-normalized. Subjects with an XX karyotype should be set to TRUE to avoid double-counting the coverage on the X chromosome. Set to FALSE if chrX coverage is already normalized.}

\item{norm.cov.matrix}{Character containing the directory or file name of the normalized coverage matrix. Generated by \code{\link{estimate_nkr}} if file doesn't exist.}

\item{scoreParams}{Data Frame storing all run parameters for the estimate_feature_score function. Can be specified by a file path to a CSV file, `data.frame`, or (if not specified) will be generated by other arguments.}

\item{file.score.coverage}{Character vector containing the input coverage file for the scoring function. Defaults to `file.coverage` if not specified.}

\item{score.cutoff}{Numeric between 0 and 1 which specifies the score filter on the results file. This parameter creates a symmetrical cutoff around 0, filtering all results whose absolute value is less than the specified value. Non-symmetrical cutoffs can be specified using `low.score.cutoff` and `high.score.cutoff`.}

\item{low.score.cutoff}{Numeric between 0 and 1 which specifies the lower score cutoff. Defaults to `score.cutoff` if not specified.}

\item{high.score.cutoff}{Numeric between 0 and 1 which specifies the upper score cutoff. Defaults to `score.cutoff` if not specified.}

\item{commands}{RCNA_analysis object storing commands and parameters from previous function runs on this object. For more information, see \code{\linkS4class{RCNA_analysis}}.}

\item{verbose}{Show more messages and warnings. Useful for debugging.}
}
\value{
A \linkS4class{RCNA_object} class object with the specified parameters.
}
\description{
An S4 class used to specify parameters for an analysis run
}
\examples{
# Create an example object - see \link{example_obj} for more information.
samples <- c("ex-sample-1", "ex-sample-2", "ex-sample-3")
ex.obj <- create_RCNA_object(sample.names = samples,
                    ano.file = system.file("examples" ,"annotations-example.csv", package = "RCNA"),
                    out.dir = "output",
                    file.raw.coverage = system.file("examples", "coverage",
                       paste0(samples, ".txt.gz"), package = "RCNA"),
                    norm.cov.matrix = file.path("output", "norm-cov-matrix.csv.gz"),
                    nkr = 0.9,
                    x.norm = "FALSE",
                    low.score.cutoff = -0.35,
                    high.score.cutoff = 0.35,
                    ncpu = 1)
class(ex.obj)
\dontshow{system("rm -rf output")}
}
\seealso{
\code{\linkS4class{RCNA_analysis}}, \code{\link{run_RCNA}}
}
