% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCGLS-functions.R
\name{stack_CGLS}
\alias{stack_CGLS}
\title{stack CGLS data}
\usage{
stack_CGLS (timeframe, product, resolution, version, variable)
}
\arguments{
\item{timeframe}{Time frame of interest, for example June 2019}

\item{product}{Product name: fapar, fcover, lai, ndvi,  ss, swi, lst, ...}

\item{resolution}{1km, 300m or 100m}

\item{version}{Version number: v1, v2, v3,...}

\item{variable}{Variable name: FAPAR_ERR, FAPAR_QFLAG... Also see https://land.copernicus.eu/global/products/}
}
\value{
CGLS data Raster Stack
}
\description{
Read all downloaded files from Copernicus Global Land Service within a timeframe as Raster Stack and adjusts coordinates for R.
}
\details{
Adjusting coordinates is a necessary step to use the data because Copernicus nc files have lat/long belonging to the centre of the pixel, and R uses upper/left corner.
}
\examples{
\dontrun{
library(raster)
TF    <- seq(as.Date("2019-06-01"), as.Date("2019-06-31"), by="days")
PROD  <- "fapar" #Product name: fapar, fcover, lai, ndvi,  ss, swi, lst, ...
RES   <- "1km" #1km, 300m or 100m
V     <- "v1" #Version number: v1, v2, v3, ...
VAR   <- "FAPAR" #FAPAR_ERR, FAPAR_QFLAG... Also see https://land.copernicus.eu/global/products/
data  <- stack_CGLS(timeframe=TF, product=PROD, resolution=RES, version=V, variable=VAR)
}
}
