% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_chisq_to_gamma.r
\name{convert_chisq_to_gamma}
\alias{convert_chisq_to_gamma}
\title{Convert parameters from a Normal-Inverse-Chi-Squared Distribution to a
Normal-Inverse-Gamma Distribution}
\usage{
convert_chisq_to_gamma(cpar)
}
\arguments{
\item{cpar}{a list of parameters including mu, kappa, nu, sigsq from a Normal-Chi-Squared distribution.}
}
\value{
A list of parameters including m, V, a, b from a Normal-Inverse-Gamma distribution.
}
\description{
Convert parameters from a Normal-Inverse-Chi-Squared distribution to a
Normal-Inverse-Gamma distribution.
}
\details{
This function convert parameters from a Normal-Inverse-Chi-Squared
(\eqn{(\mu,\sigma^2) \sim NIX({\sf mean}=\mu,{\sf effective sample size}=\kappa,{\sf degrees of freedom}=\nu,{\sf variance}=\sigma^2/\kappa)}) 
distribution to a Normal-Inverse-Gamma 
(\eqn{(\mu,\sigma^2) \sim NIG({\sf mean}=m,{\sf variance}=V \times \sigma^2,{\sf shape}=a,{\sf rate}=b)}) 
distribution.
}
\examples{
convert_chisq_to_gamma(list(mu=0.091,kappa=2,nu=1,sigsq=4e-05))
}
\references{
\insertRef{Kevin2007}{RARtrials}
}
