% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_funs.r
\name{read_pars}
\alias{read_pars}
\alias{read_psv}
\alias{read_rep}
\title{Read in parameters from an AD Model Builder run}
\usage{
read_pars(fn, drop_phase = TRUE, covfn = "admodel.cov",
  warn_nonstd_rep = TRUE)

read_psv(fn, names = NULL)

read_rep(fn, names = NULL, warn_nonstd_rep = TRUE)
}
\arguments{
\item{fn}{(character) Base name of AD Model Builder}

\item{drop_phase}{(logical) drop negative-phase (fixed) parameters from results?}

\item{covfn}{(character) file name for covariance matrix information}

\item{warn_nonstd_rep}{warn if report file is in nonstandard format?}

\item{names}{(character) Names of variables}
}
\value{
List containing the following elements
\itemize{
\item{coefficients}{parameter estimates}
\item{coeflist}{parameter estimates in list format, with proper shape (vectors, matrices, etc.)}
\item{se}{estimated standard errors of coefficients}
\item{loglik}{log-likelihood}
\item{maxgrad}{maximum gradient of log-likelihood surface}
\item{cor}{correlation matrix}
\item{vcov}{variance-covariance matrix}
\item{npar}{number of parameters}
\item{hes}{hessian matrix (only if no vcov matrix)}
\item{report}{values from report file (if non-standard report file)}
}
}
\description{
Reads coefficients, standard errors, log-likelihoods, maximum gradients,
correlation and variance-covariance matrices from AD Model Builder output
files
}
\details{
Given the output from an ADMB run on FOO.tpl, \code{read_pars} reads the
files FOO.par (parameters, log-likelihood, max gradient); FOO.std (standard
deviations); FOO.cor (correlations); FOO.rep (report variables);
admodel.hes for hessian; and admodel.cov for
covariance matrix.  \code{read_psv} reads the output of MCMC runs.


\itemize{
\code{read_rep} (called by \code{read_admb} to read the \code{.rep} file) first
checks if the report file is in a standard format: first line starts with a
comment character (#); thereafter, each block starts with a single commented
line containing the name of the parameter (possibly ending with a colon),
followed by a block of all-numeric lines, which are read as a single vector.
If the report file is in a standard format, the values are added to the end
of the coefficients list.  Otherwise, the numeric values from the report file
are included in the results as a single, concantenated numeric vector.
}
}
\section{Warnings}{

\itemize{
\item{The \code{coeflist} component is untested for data
structures more complicated than scalars, vectors or matrices (i.e. higher-dimensional or ragged arrays)}
\item{Because ADMB hard-codes the file name for covariance matrix information (\code{admodel.cov}), care is necessary when running different models in the same directory; users may want to rename this file by hand and use the \code{covfn} argument}
}
}

\seealso{
\code{\link{write_pin}}, \code{\link{write_dat}}
}
\keyword{misc}
