% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QuantNorm.R
\name{QuantNorm}
\alias{QuantNorm}
\title{Adjust the distance matrix by quantile normalization for data with batch effect}
\usage{
QuantNorm(dat, batch, method = "row/column", cor_method = "spearman",
  tol = 0.01, max = 50, logdat = TRUE, standardize = FALSE)
}
\arguments{
\item{dat}{The original p*n batch effect data with n subjects and p RNA-seq measurements or the n by n distance matrix.}

\item{batch}{The vector of length n indicating which batch the subjects belong to.}

\item{method}{Method for the quantile normalization. There are two options: "row/column" and "vectorize".}

\item{cor_method}{Method to calculate the correlation matrix, can be 'spearman'(default), 'pearson' or 'kendall'.}

\item{tol}{The tolerance for the iterative method "row/column", which is the Euclidean distance of the vectorized two dissimilarity matrices before and after each iteration.}

\item{max}{Maximum number of the iteration if the tolerance is not reached.}

\item{logdat}{Whether conducting log transformation to data or not.}

\item{standardize}{Whether conducting standardization [(dat - mean)/sqrt(var)] to data or not.}
}
\value{
Returns the corrected 1-correlation matrix between subjects.
}
\description{
This function applies quantile normalization on the distance matrix (dissimilarity matrix) and return the corrected distance matrix.
}
\examples{

library(pheatmap) #drawing heatmap

data("ENCODE") #load the ENCODE data

#Before correction, the subjects are clustered by species
pheatmap(cor(ENCODE))

#Assigning the batches based on species
batches <- c(rep(1,13),rep(2,13))

#QuantNorm correction
corrected.distance.matrix <- QuantNorm(ENCODE,batches,method='row/column', cor_method='pearson',
                                       logdat=FALSE, standardize = TRUE, tol=1e-4)
pheatmap(1-corrected.distance.matrix)
}
\references{
Fei et al (2018), Mitigating the adverse impact of batch effects in sample pattern detection, Bioinformatics, <https://doi.org/10.1093/bioinformatics/bty117>.
}
\author{
Teng Fei. Email: tfei@emory.edu
}
