% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generalFunctions.R
\name{discount.factors}
\alias{discount.factors}
\title{Discount factors}
\usage{
discount.factors(
  dates,
  rates,
  analysis.date = Sys.Date(),
  rate.type = 1,
  freq = 1
)
}
\arguments{
\item{dates}{Coupon payment dates.}

\item{rates}{Discount rates given by the zero coupon rate curve.
Can also be a unique discount rate.}

\item{analysis.date}{Date in which the asset is valued. By default, the
current date.}

\item{rate.type}{(1) for discrete compounded discount rates and (0) for continuosly
compounded discount rates. By default rates are assumed to be discrete.}

\item{freq}{Frequency of payments of a given asset in a year. For LIBOR and
IBR the default frequency is four (quarterly payments). TES has a default
frequency of one (annual payments).}
}
\value{
Discount factors.
}
\description{
Function that calculates discount factors given effective payment dates
and a discount rate. Optional parameters available to calculate discrete
or continuous discount factors.
}
\examples{
discount.factors(dates = c("2020-09-10", "2020-12-10", "2021-03-10"), rates = c(0.07, 0.075, 0.08),
                 analysis.date = "2010-09-01")
discount.factors(dates = c("2025-09-01", "2025-12-01", "2026-03-01", "2026-06-01"),
                 rates = c(0.01, 0.015, 0.017, 0.02), analysis.date = "2025-06-01",
                 rate.type = 1, freq = 4)

}
