% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quanda.R
\name{quanda}
\alias{quanda}
\title{Fit QuanDA for imbalanced binary classification}
\usage{
quanda(
  x,
  y,
  lambda = 10^(seq(1, -4, length.out = 30)),
  lam2 = 0.01,
  n_rep = 10,
  tau_window = 0.05,
  nfolds = 5,
  maxit = 10000,
  eps = 1e-07,
  maxit_cv = 10000,
  eps_cv = 1e-05
)
}
\arguments{
\item{x}{A numeric matrix of predictors with \eqn{n} rows (observations) and \eqn{p} columns (features).}

\item{y}{A binary response vector of length \eqn{n} with values \code{0} or \code{1}.}

\item{lambda}{Optional numeric vector of penalty values (largest \code{lambda[1]}).
If \code{NULL}, a default sequence will be generated from the data.}

\item{lam2}{Numeric, secondary penalty (ridge/elastic term) passed to \code{hdqr}. Default \code{0.01}.}

\item{n_rep}{Integer, number of jittering repetitions (averaged). Default \code{10}.}

\item{tau_window}{Width around the class rate to explore quantiles.
Candidate \eqn{\tau} are \eqn{b + \{-w,\ldots,w\}} in steps of 0.01,
clipped to \eqn{[0,1]}, where \eqn{b} is the class rate and \eqn{w} is \code{tau_window}.
Default \code{0.1}.}

\item{nfolds}{Integer, number of CV folds used by \code{cv_z()}. Default \code{5}.}

\item{maxit, maxit_cv, eps, eps_cv}{Controls for inner optimizers and CV helper.}
}
\value{
An object of class \code{"quanda"} with elements:
\describe{
  \item{beta}{Numeric vector of length \eqn{p+1} (intercept first).}
  \item{tau_grid}{Numeric vector of candidate \eqn{\tau} values.}
  \item{tau_best}{Chosen \eqn{\tau}.}
  \item{auc}{Vector of AUCs across \eqn{\tau}.}
  \item{call}{The matched call.}
}
}
\description{
QuanDA fits a quantile-regression-based discriminant with label jittering.
For each candidate quantile level \eqn{\tau}, the binary labels are jittered
(adding \eqn{U(0,1)}), a penalized quantile regression is fit multiple times,
and the coefficient vectors are averaged. The best \eqn{\tau} is selected by AUC.
}
\details{
We jitter labels via \eqn{z_i = y_i + U_i}, where \eqn{U_i \sim \mathrm{Unif}(0,1)},
fit penalized quantile regression at multiple \eqn{\tau}, average coefficients over \code{n_rep} jitters,
compute AUCs on the original \eqn{(x,y)}, and pick the \eqn{\tau} that maximizes AUC.
}
\examples{
data(breast)
X <- as.matrix(X)
y <- as.numeric(as.character(y))
y[y==-1]=0
\donttest{fit <- quanda(X, y)}
\donttest{pred <- predict(fit, tail(X))}
}
\keyword{binary-classification}
\keyword{imbalanced-learning}
\keyword{quantile}
\keyword{regression}
