% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SummarizeResult.R
\name{SummarizeResult}
\alias{SummarizeResult}
\title{Summarize Analysis Results}
\usage{
SummarizeResult(
  analysis = NULL,
  calculation,
  sig_method = "xth_percent",
  method_threshold = 50
)
}
\arguments{
\item{analysis}{Output of \code{GetAnalysis()}.}

\item{calculation}{Output of \code{GetCalculation()}.}

\item{sig_method}{Specifies the approach for determining sample-level result.
Available options include "xth_percent", "metric_count", "xth_count",
or any metric name present in the analysis list. The default is "xth_percent".}

\item{method_threshold}{Defines the threshold value for the "metric_count",
"xth_count", and "xth_percent" methods. This parameter defaults to 50.}
}
\value{
A data frame summarizing results of the analysis and calculation, with columns:

\itemize{
\item result: Overall result based on the chosen method

\item position: Location of the sample replications based on plate layout

\item method: Method chosen for determination of the result

\item *_sig: Significance indicator for each metric

\item *_p: P-value or adjusted p-value for each metric

\item metric_count: Count of significant results across all analyses

\item xth_count: The number of reactions crossing the fluorescent threshold

\item total_rep: Total number of replicates

\item xth_percent: Percentage of replicates crossing the fluorescent threshold
}
}
\description{
This function combines analysis results from multiple tests with metadata,
and determines overall significance based on a specified method. By default, it
evaluates sample-level result by calculating the percentage of technical replicates
that exceed the pre-defined threshold.
}
\examples{
# Define the path to the plate data file
plate_path <- system.file("extdata/20240716_p3", 
                          file = '20240716_p3_plate.xlsx', 
                          package = "QuICSeedR")
  
# Read the plate data
plate <- readxl::read_xlsx(plate_path)

# Define the path to the raw data file
raw_path <- system.file("extdata/20240716_p3", 
                        file = '20240716_p3_raw.xlsx', 
                        package = "QuICSeedR")
# Read the raw data
raw <- readxl::read_xlsx(raw_path)

# Get replicate data
replicate <- GetReplicate(plate)

# Ensure time displayed as decimal hours
plate_time = ConvertTime(raw)

#Get metadata and display the few rows 
meta = CleanMeta(raw, plate, replicate)

#Clean data 
cleanraw <- CleanRaw(meta, raw, plate_time)

#Get calculations using positive controls to normalize values. 
calculation = GetCalculation(raw = cleanraw, meta, sd_fold = 10)

#Formatting calculations for analysis (also compatible with graphing softwares used in F-SAA 
#research)
calculation_spread = SpreadCalculation(calculation)

#Get analysis comparing samples to negative control using the one-tailed Wilcox Rank-Sum test.
analysis <- GetAnalysis(calculation_spread, control = "Neg", test = "wilcox", 
                        alternative = 'greater')
                        
#Summarization of results. Default method is rate of amyloid formation.
result <- SummarizeResult(analysis, calculation)

head(result)

}
