% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rSplit.R
\name{rSplit}
\alias{rSplit}
\title{Stratified Random Split Sampling}
\usage{
rSplit(y, nsplit, stratify = TRUE, s_ratio = 0.8, ...)
}
\arguments{
\item{y}{a \link[base]{double} \link[base]{vector},
a \link[base]{logical} \link[base]{vector},
a \link[base]{factor},
or a \link[survival]{Surv} object,
response \eqn{y}}

\item{nsplit}{positive \link[base]{integer} scalar, number of \link[base]{replicate}s of random splits to be performed}

\item{stratify}{\link[base]{logical} scalar,
whether stratification based on response \eqn{y} needs to be implemented, default \code{TRUE}}

\item{s_ratio}{\link[base]{double} scalar between 0 and 1,
split ratio, i.e., percentage of training subjects \eqn{p}, default \code{.8}}

\item{...}{additional parameters, currently not in use}
}
\value{
Function \link{rSplit} returns a length-\code{nsplit} \link[base]{list} of
\link[base]{logical} \link[base]{vector}s.
In each \link[base]{logical} \link[base]{vector},
the \code{TRUE} elements indicate training subjects and
the \code{FALSE} elements indicate test subjects.
}
\description{
Random split sampling, stratified based on the type of the response.
}
\details{
Function \link{rSplit} performs random split sampling,
with or without stratification. Specifically,

\itemize{

\item If \code{stratify = FALSE},
or if we have a \link[base]{double} response \eqn{y},
then split the sample into a training and a test set by odds \eqn{p/(1-p)}, without stratification.

\item Otherwise, split a \link[survival]{Surv} response \eqn{y}, stratified by its censoring status.
Specifically,
split subjects with observed event into a training and a test set by odds \eqn{p/(1-p)},
and split the censored subjects into a training and a test set by odds \eqn{p/(1-p)}.
Then combine the training sets from subjects with observed events and censored subjects,
and combine the test sets from subjects with observed events and censored subjects.

\item Otherwise, split a \link[base]{logical} response \eqn{y}, stratified by itself.
Specifically,
split the subjects with \code{TRUE} response into a training and a test set by odds \eqn{p/(1-p)},
and split the subjects with \code{FALSE} response into a training and a test set by odds \eqn{p/(1-p)}.
Then combine the training sets, and the test sets, in a similar fashion as described above.

\item Otherwise, split a \link[base]{factor} response \eqn{y}, stratified by its \link[base]{levels}.
Specifically,
split the subjects in each level of \eqn{y} into a training and a test set by odds \eqn{p/(1-p)}.
Then combine the training sets, and the test sets, from all levels of \eqn{y}.

}
}
\note{
\code{caTools::sample.split} is not what we need.
}
\examples{
rSplit(y = rep(c(TRUE, FALSE), times = c(20, 30)), nsplit = 3L)

}
\seealso{
\link[base]{split}, \code{caret::createDataPartition}
}
\keyword{internal}
