% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progeny.R
\name{progeny}
\alias{progeny}
\title{Progeny Simulation}
\usage{
progeny(
  QTL,
  marker,
  type = "RI",
  ng = 2,
  cM = TRUE,
  E.vector = NULL,
  h2 = 0.5,
  size = 200
)
}
\arguments{
\item{QTL}{matrix. A q*2 matrix contains the QTL information, where the
row dimension 'q' represents the number of QTLs in the chromosomes. The
first column labels the chromosomes where the QTLs are located, and the
second column labels the positions of QTLs (in morgan (M) or centimorgan
(cM)).}

\item{marker}{matrix. A k*2 matrix contains the marker information,
where the row dimension 'k' represents the number of markers in the
chromosomes. The first column labels the chromosomes where the markers
are located, and the second column labels the positions of markers (in
morgan (M) or centimorgan (cM)). It's important to note that chromosomes
and positions must be sorted in order.}

\item{type}{character. The population type of the dataset. Includes
backcross (type="BC"), advanced intercross population (type="AI"), and
recombinant inbred population (type="RI"). The default value is "RI".}

\item{ng}{integer. The generation number of the population type. For
instance, in a BC1 population where type="BC", ng=1; in an AI F3
population where type="AI", ng=3.}

\item{cM}{logical. Specify the unit of marker position. If cM=TRUE, it
denotes centimorgan; if cM=FALSE, it denotes morgan.}

\item{E.vector}{vector. Set the effect of QTLs. It should be a named
vector, where the names of elements represent the effects of QTLs and
their interactions. For example: the additive effect of QTL1 is coded as
"a1"; the dominant effect of QTL2 is coded as "d2"; the interaction of
the additive effect of QTL2 and the dominant effect of QTL1 is coded as
"a2:d1". So, if the additive effect of QTL1 is 2, the dominant effect of
QTL2 is 5, and the interaction of the additive effect of QTL2 and the
dominant effect of QTL1 is 3, the user should input: E.vector = c("a1"=2,
"d2"=5, "a2:d1"=3). If E.vector=NULL, the phenotypic value will not be
simulated.}

\item{h2}{numeric. Set the heritability for simulated phenotypes. It
should be a number between 0 and 1.}

\item{size}{numeric. The population size of simulated progeny.}
}
\value{
\item{phe}{The phenotypic value of each simulated progeny.}
\item{E.vector}{The effect vector used in this simulation.}
\item{marker.prog}{The marker genotype of each simulated progeny.}
\item{QTL.prog}{The QTL genotype of each simulated progeny.}
\item{VG}{The genetic variance of this population.}
\item{VE}{The environmental variance of this population.}
\item{genetic.value}{The genetic value of each simulated progeny.}
}
\description{
Generate simulated phenotype and genotype data for a specified
generation from various breeding schemes.
}
\examples{
# load the example data
load(system.file("extdata", "exampledata.RDATA", package = "QTLEMM"))

# run and result
result <- progeny(QTL, marker, type = "RI", ng = 5, E.vector = c("a1" = 2, "d2" = 5, "a2:d1" = 3),
h2 = 0.5, size = 200)
result$phe
}
\references{
Haldane J.B.S. 1919. The combination of linkage values and the calculation
of distance between the loci for linked factors. Genetics 8: 299–309.
}
