% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfasa.R
\name{testfordiff.ind.pval}
\alias{testfordiff.ind.pval}
\title{Test for a difference between two independent samples of compositional data.
Zeros of any type are allowed.}
\usage{
testfordiff.ind.pval(compdata.1, compdata.2, R = 500)
}
\arguments{
\item{compdata.1}{sample of compositional data.}

\item{compdata.2}{sample of compositional data.}

\item{R}{number of bootstrap samples, default is 500.}
}
\value{
p-value obtained through a multivariate permutation test with test statistic based
on chi-square distances.
}
\description{
Test for a difference between two independent samples of compositional data.
Zeros of any type are allowed.
}
\examples{

## Prey
data(preyFAs)

## Capelin FA sig
capelin.sig=preyFAs[preyFAs$Species=="capelin",4:(ncol(preyFAs))]
capelin.sig=capelin.sig/apply(capelin.sig,1,sum)

## Sandlance FA sig
sandlance.sig=preyFAs[preyFAs$Species=="sandlance",4:(ncol(preyFAs))]
sandlance.sig=sandlance.sig/apply(sandlance.sig,1,sum)

# Note:
# # Uncomment examples to run. CRAN tests fail because execution time > 5 seconds
# testfordiff.ind.pval(as.matrix(capelin.sig),as.matrix(sandlance.sig))


}
\references{
Stewart, C., Iverson, S. and Field, C. (2014) Testing for a change in
diet using fatty acid signatures.  Environmental and Ecological Statistics 21, pp. 775-792.
}
