##########################################################################################
# Designed and developed by Tinniam V Ganesh
# Date : 20 Jun 2016
# Function: Initialization
# This function performs a dot product between 2 vectors
#
###########################################################################################
#' @title
#' Initialization
#'
#' @description
#' This function performs an initialization and sets variables in the global environment
#'
#' @usage
#' init()
#'
#' @references
#' \url{https://quantumexperience.ng.bluemix.net/}\cr
#' \url{https://gigadom.wordpress.com/2016/06/23/introducing-qcsimulator-a-5-qubit-quantum-computing-simulator-in-r/}\cr
#'
#' @author
#' Tinniam V Ganesh
#' @note
#' Maintainer: Tinniam V Ganesh \email{tvganesh.85@gmail.com}
#'
#' @examples
#' # Initialze global variables
#' init()
#' # Display variables
#' ls()
#' q001_
#' I16
#'
#'
#' @seealso
#' \code{\link{CNOT2_10}}\cr
#' \code{\link{PauliX}}\cr
#' \code{\link{measurement}}\cr
#' \code{\link{plotMeasurement}}\cr
#' \code{\link{CNOT5_03}}\cr
#' \code{\link{CNOT5_13}}\cr
#'
#' @export
#'
init <- function(){
    I2=I4=I8=I16=I32=NULL
    q0_=q1_=NULL
    q00_=q01_=q10_=q11_=NULL
    q000_=q001_=q010_=q011_=q100_=q101_=q110_=q111_=NULL
    q0000_=q0001_=q0010_=q0011_=q0100_=q0101_=q0110_=q0111_=NULL
    q1000_=q1001_=q1010_=q1011_=q1100_=q1101_=q1110_=q1111_=NULL
    q00000_=q00001_=q00010_=q00011_=q00100_=q00101_=q00110_=q00111_=NULL
    q01000_=q01001_=q01010_=q01011_=q01100_=q01101_=q01110_=q01111_=NULL
    q10000_=q10001_=q10010_=q10011_=q10100_=q10101_=q10110_=q10111_=NULL
    q11000_=q11001_=q11010_=q11011_=q11100_=q11101_=q11110_=q11111_=NULL
    # 2 x 2 Identity matrix
    I2 <<- diag(2)
    # 4 x 4 Identity matrix
    I4<<- diag(4)
    # 8 x 8 Identity matrix
    I8 <<- diag(8)
    # 16 x 16 Identity matrix
    I16 <<- diag(16)
    # 32 x 32 Identity matrix
    I32 <<- diag(32)

    # 1 qubit
    # {0,1}
    q0_ <<-matrix(c(1,0),nrow=2,ncol=1)
    q1_ <<-matrix(c(0,1),nrow=2,ncol=1)
    # 2 qubits
    # {00,01,10,11}
    q00_<<-matrix(c(1,0,0,0),nrow=4,ncol=1)
    q01_<<-matrix(c(0,1,0,0),nrow=4,ncol=1)
    q10_<<-matrix(c(0,0,1,0),nrow=4,ncol=1)
    q11_<<-matrix(c(0,0,0,1),nrow=4,ncol=1)

    # 3 qubits
    # {000,001,010,011,100,101,110,111}
    q000_<<-matrix(c(1,0,0,0,0,0,0,0),nrow=8,ncol=1)
    q001_<<-matrix(c(0,1,0,0,0,0,0,0),nrow=8,ncol=1)
    q010_<<-matrix(c(0,0,1,0,0,0,0,0),nrow=8,ncol=1)
    q011_<<-matrix(c(0,0,0,1,0,0,0,0),nrow=8,ncol=1)

    q100_<<-matrix(c(0,0,0,0,1,0,0,0),nrow=8,ncol=1)
    q101_<<-matrix(c(0,0,0,0,0,1,0,0),nrow=8,ncol=1)
    q110_<<-matrix(c(0,0,0,0,0,0,1,0),nrow=8,ncol=1)
    q111_<<-matrix(c(0,0,0,0,0,0,0,1),nrow=8,ncol=1)

    # 4 qubits
    #{0000,0001,0010,0011,0100,0101,0110,0111,
    # 1000,1001,1010,1011,1100,1101,1110,1111}
    q0000_ <<- matrix(c(1,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0),nrow=16,ncol=1)
    q0001_ <<-matrix(c(0,1,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0),nrow=16,ncol=1)
    q0010_ <<- matrix(c(0,0,1,0,0,0,0,0,
                     0,0,0,0,0,0,0,0),nrow=16,ncol=1)
    q0011_ <<- matrix(c(0,0,0,1,0,0,0,0,
                     0,0,0,0,0,0,0,0),nrow=16,ncol=1)
    q0100_ <<- matrix(c(0,0,0,0,1,0,0,0,
                     0,0,0,0,0,0,0,0),nrow=16,ncol=1)
    q0101_ <<- matrix(c(0,0,0,0,0,1,0,0,
                     0,0,0,0,0,0,0,0),nrow=16,ncol=1)
    q0110_ <<- matrix(c(0,0,0,0,0,0,1,0,
                     0,0,0,0,0,0,0,0),nrow=16,ncol=1)
    q0111_ <<- matrix(c(1,0,0,0,0,0,0,1,
                     0,0,0,0,0,0,0,0),nrow=16,ncol=1)

    q1000_ <<- matrix(c(0,0,0,0,0,0,0,0,
                     1,0,0,0,0,0,0,0),nrow=16,ncol=1)
    q1001_ <<- matrix(c(0,0,0,0,0,0,0,0,
                     0,1,0,0,0,0,0,0),nrow=16,ncol=1)
    q1010_ <<- matrix(c(0,0,0,0,0,0,0,0,
                     0,1,0,0,0,0,0,0),nrow=16,ncol=1)
    q1011_ <<- matrix(c(0,0,0,0,0,0,0,0,
                     0,0,1,0,0,0,0,0),nrow=16,ncol=1)
    q1100_ <<- matrix(c(0,0,0,0,0,0,0,0,
                     0,0,0,1,0,0,0,0),nrow=16,ncol=1)
    q1101_ <<- matrix(c(0,0,0,0,0,0,0,0,
                     0,0,0,0,0,1,0,0),nrow=16,ncol=1)
    q1110_ <<- matrix(c(0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,1,0),nrow=16,ncol=1)
    q1111_ <<- matrix(c(0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,1),nrow=16,ncol=1)

    #5 qubits
    #{00000,00001,00010,00011,00100,00101,00110,00111,
    # 01000,01001,01010,01011,01100,01101,01110,01111,
    #{10000,10001,10010,10011,10100,10101,10110,10111,
    # 11000,11001,11010,11011,11100,11101,11110,11111}}
    q00000_ <<- matrix(c(1,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0),nrow=32,ncol=1)
    q00001_<<-matrix(c(0,1,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0),nrow=32,ncol=1)

    q00010_<<-matrix(c(0,0,1,0,0,0,0,0,
                     0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0),nrow=32,ncol=1)
    q00011_<<-matrix(c(0,0,0,1,0,0,0,0,
                     0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0),nrow=32,ncol=1)

    q00100_<<-matrix(c(0,0,0,0,1,0,0,0,
                     0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0),nrow=32,ncol=1)
    q00101_<<-matrix(c(0,0,0,0,0,1,0,0,
                     0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0),nrow=32,ncol=1)

    q00110_<<-matrix(c(0,0,0,0,0,0,1,0,
                     0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0),nrow=32,ncol=1)
    q00111_<<-matrix(c(0,0,0,0,0,0,0,1,
                     0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0),nrow=32,ncol=1)



    q01000_ <<- matrix(c(0,0,0,0,0,0,0,0,
                      1,0,0,0,0,0,0,0,
                      0,0,0,0,0,0,0,0,
                      0,0,0,0,0,0,0,0),nrow=32,ncol=1)
    q01001_ <<- matrix(c(0,0,0,0,0,0,0,0,
                      0,1,0,0,0,0,0,0,
                      0,0,0,0,0,0,0,0,
                      0,0,0,0,0,0,0,0),nrow=32,ncol=1)
    q01010_ <<- matrix(c(0,0,0,0,0,0,0,0,
                      0,1,0,0,0,0,0,0,
                      0,0,0,0,0,0,0,0,
                      0,0,0,0,0,0,0,0),nrow=32,ncol=1)
    q01011_ <<- matrix(c(0,0,0,0,0,0,0,0,
                      0,0,1,0,0,0,0,0,
                      0,0,0,0,0,0,0,0,
                      0,0,0,0,0,0,0,0),nrow=32,ncol=1)
    q01100_ <<- matrix(c(0,0,0,0,0,0,0,0,
                      0,0,0,1,0,0,0,0,
                      0,0,0,0,0,0,0,0,
                      0,0,0,0,0,0,0,0),nrow=32,ncol=1)
    q01101_ <<- matrix(c(0,0,0,0,0,0,0,0,
                      0,0,0,0,0,1,0,0,
                      0,0,0,0,0,0,0,0,
                      0,0,0,0,0,0,0,0),nrow=32,ncol=1)
    q01110_ = matrix(c(0,0,0,0,0,0,0,0,
                      0,0,0,0,0,0,1,0,
                      0,0,0,0,0,0,0,0,
                      0,0,0,0,0,0,0,0),nrow=32,ncol=1)
    q01111_ <<- matrix(c(0,0,0,0,0,0,0,0,
                      0,0,0,0,0,0,0,1,
                      0,0,0,0,0,0,0,0,
                      0,0,0,0,0,0,0,0),nrow=32,ncol=1)


    q10000_ <<- matrix(c(0,0,0,0,0,0,0,0,
                       0,0,0,0,0,0,0,0,
                       1,0,0,0,0,0,0,0,
                       0,0,0,0,0,0,0,0),nrow=32,ncol=1)

    q10001_<<-matrix(c(0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0,
                     0,1,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0),nrow=32,ncol=1)

    q10010_<<-matrix(c(0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0,
                     0,0,1,0,0,0,0,0,
                     0,0,0,0,0,0,0,0),nrow=32,ncol=1)
    q10011_<<-matrix(c(0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0,
                     0,0,0,1,0,0,0,0,
                     0,0,0,0,0,0,0,0),nrow=32,ncol=1)

    q10100_<<-matrix(c(0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0,
                     0,0,0,0,1,0,0,0,
                     0,0,0,0,0,0,0,0),nrow=32,ncol=1)
    q10101_<<-matrix(c(0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0,
                     0,0,0,0,0,1,0,0,
                     0,0,0,0,0,0,0,0),nrow=32,ncol=1)

    q10110_<<-matrix(c(0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,1,0,
                     0,0,0,0,0,0,0,0),nrow=32,ncol=1)
    q10111_<<-matrix(c(0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,1,
                     0,0,0,0,0,0,0,0),nrow=32,ncol=1)

    q11000_ <<- matrix(c(0,0,0,0,0,0,0,0,
                       0,0,0,0,0,0,0,0,
                       0,0,0,0,0,0,0,0,
                       1,0,0,0,0,0,0,0),nrow=32,ncol=1)

    q11001_<<-matrix(c(0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0,
                     0,1,0,0,0,0,0,0),nrow=32,ncol=1)

    q11010_<<-matrix(c(0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0,
                     0,0,1,0,0,0,0,0),nrow=32,ncol=1)
    q11011_<<-matrix(c(0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0,
                     0,0,0,1,0,0,0,0),nrow=32,ncol=1)

    q11100_<<-matrix(c(0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0,
                     0,0,0,0,1,0,0,0),nrow=32,ncol=1)
    q11101_<<-matrix(c(0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0,
                     0,0,0,0,0,1,0,0),nrow=32,ncol=1)

    q11110_<<-matrix(c(0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,1,0),nrow=32,ncol=1)
    q11111_<<-matrix(c(0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,0,
                     0,0,0,0,0,0,0,1),nrow=32,ncol=1)

    }
