% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_records_to_df.R
\name{list_records_to_df}
\alias{list_records_to_df}
\title{Convert a list of records to a data.frame}
\usage{
list_records_to_df(x)
}
\arguments{
\item{x}{A list of records. Each record should be a named list or similar structure.
Records may have different sets of fields.}
}
\value{
A \code{data.frame} with one row per record and columns corresponding to the
union of all field names.
}
\description{
Converts a list where each element represents a record (row) into a
\code{data.frame}. Missing fields are filled with \code{NA}.
}
\details{
List-valued fields are flattened by collapsing their contents into a single
character value. This guarantees that the returned data frame contains no
list columns, but nested structure is not preserved.

This function is intended for row-oriented data structures, such as JSON
arrays of objects.
}
\note{
This function is written and documented with help from ChatGPT.
}
\examples{
x <- list(
  list(id = 1, name = "Ada", tags = list("a", "b")),
  list(id = 2, name = "Bo"),
  list(id = 3, name = "Cy", tags = list("x"))
)

list_records_to_df(x)

}
