% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text-mining.R
\name{pubmed_textmining}
\alias{pubmed_textmining}
\title{Pubmed-textmining}
\usage{
pubmed_textmining(fixterms, pubterms, output)
}
\arguments{
\item{fixterms}{The input argument fixterms refers to any term that strongly relates to your focus of research. Either a string or a vector of strings.}

\item{pubterms}{The input argument pubterms recapitulates any terms you wish to pivot around your research focus. Either a string or a vector of strings.}

\item{output}{The output argument defines the directory you wish to store the generated text files. Default is your current location.}
}
\value{
Returns text files with pmi-scores for each fixterm and text files for every collocation pairs bearing the article titles and publishing years. Authors will follow in the next version.
}
\description{
Function for text-mining the PubMed repository based on defined sets of terms.
The relationship between fixterms (related to your research topic) and pubterms (terms which pivot around your research focus)
is calculated using the pointwise mutual information algorithm. A text file is generated with the pmi-scores for each fixterm.
Then for each collocation pairs (a fixterm + a pubterm), a text file is generated with related article titles and publishing years.
Additional Author section will follow in the next version updates.
}
\examples{
\dontrun{
fixterms = c("bike", "downhill")
pubterms = c("dangerous", "extreme", "injuries")
output = getwd() #or "YOUR/DESIRED/OUTPUT/PATHWAY"
pubmed_textmining(fixterms, pubterms, output)
}
}
