% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot_distrib}
\alias{plot_distrib}
\title{Plot the posterior distribution of the difference of means}
\usage{
plot_distrib(
  sample_distrib,
  group1 = NULL,
  group2 = NULL,
  peptide = NULL,
  prob_CI = 0.95,
  show_prob = TRUE,
  mean_bar = TRUE,
  index_group1 = NULL,
  index_group2 = NULL
)
}
\arguments{
\item{sample_distrib}{A data frame, typically coming from the
\code{sample_distrib()} function, containing the following columns:
\code{Peptide}, \code{Group} and \code{Sample}. This argument should
contain the empirical posterior distributions to be displayed.}

\item{group1}{A character string, corresponding to the name of the group
for which we plot the posterior distribution of the mean. If NULL
(default), the first group appearing in \code{sample_distrib} is
displayed. If \code{group2} is provided, the posterior difference of the
groups is displayed instead.}

\item{group2}{A character string, corresponding to the name of the group
we want to compare to \code{group1}. If NULL (default), only the posterior
distribution of the mean for \code{group1} is displayed.}

\item{peptide}{A character string, corresponding to the name of the peptide
for which we plot the posterior distribution of the mean. If NULL
(default), only the first appearing in \code{sample_distrib} is displayed.}

\item{prob_CI}{A number, between 0 and 1, corresponding the level of the
Credible Interval (CI), represented as side regions (in red) of the
posterior distribution. The default value (0.95) display the 95\% CI,
meaning that the central region (in blue) contains 95\% of the probability
distribution of the mean.}

\item{show_prob}{A boolean, indicating whether we display the label of
probability comparisons between the two groups.}

\item{mean_bar}{A boolean, indicating whether we display the vertical bar
corresponding to 0 on the x-axis (when comparing two groups), of the mean
value of the distribution (when displaying a unique group).}

\item{index_group1}{A character string, used as the index of \code{group1} in
the legends. If NULL (default), \code{group1} is used.}

\item{index_group2}{A character string, used as the index of \code{group2} in
the legends. If NULL (default), \code{group2} is used.}
}
\value{
Plot of the required posterior distribution.
}
\description{
Display the posterior distribution of the difference of means between two
groups for a specific peptide. If only one group is provide, the function
display the posterior distribution of the mean for this specific group
instead. The function provides additional tools to represent information to
help inference regarding the difference between groups (reference at 0 on the
x-axis, probability of \code{group1} > \code{group2} and conversely).
}
\examples{
TRUE
}
