% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariate.R
\name{bicenter}
\alias{bicenter}
\title{Double centering of a matrix.}
\usage{
bicenter(m)
}
\arguments{
\item{m}{a \code{numeric} matrix}
}
\value{
a \code{numeric} matrix centred by rows
          and columns
}
\description{
colSums and rowSums of the returned matrix are all equal to zero.
}
\details{
Inspired from the algorithm described in stackoverflow
\url{https://stackoverflow.com/questions/43639063/double-centering-in-r}
}
\examples{
data(bacteria)
bact_bc <- bicenter(bacteria)
sum(rowSums(bact_bc))
sum(colSums(bact_bc))

}
\author{
Eric Coissac

Christelle Gonindard-Melodelima
}
