% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06PTModule.r
\name{rawToPTModule}
\alias{rawToPTModule}
\alias{rawToPTModule,raw-method}
\title{Convert a vector of raw data into a PTModule object}
\usage{
\S4method{rawToPTModule}{raw}(x, ignore.validity = FALSE)
}
\arguments{
\item{x}{A vector of \code{raw} data, conform ProTracker file specs.}

\item{ignore.validity}{A \code{logical} value. When set as \code{TRUE}
this method will attempt to decode the raw data (\code{x}), even when it is invalid.
When set to \code{FALSE} (default) validity is checked and an error is
thrown when invalidity occurs.}
}
\value{
returns a \code{\linkS4class{PTModule}} object.
}
\description{
This method treats a vector of \code{raw} data as if it where a
file, and converts it into a \code{\linkS4class{PTModule}} object.
}
\details{
Data is read from a vector of \code{raw} data as if it where a file
and converted into a \code{\linkS4class{PTModule}} object. This
method can be useful for module files stored on virtual Amiga Disk Files
(adf), which can be read as raw data, using the \code{AmigaFFH}
package.

Use \code{\link{as.raw}} to achieve the inverse.
}
\examples{
## convert the example mod into raw data
data("mod.intro")
mod.raw <- as.raw(mod.intro)

## restore it as a PTModule-class object
mod.restored <- rawToPTModule(mod.raw)

## In this case the result is identical to the original:
identical(mod.restored, mod.intro)
}
\seealso{
Other module.operations: 
\code{\link{PTModule-class}},
\code{\link{appendPattern}()},
\code{\link{clearSamples}()},
\code{\link{clearSong}()},
\code{\link{deletePattern}()},
\code{\link{fix.PTModule}()},
\code{\link{modToWave}()},
\code{\link{moduleSize}()},
\code{\link{patternLength}()},
\code{\link{patternOrderLength}()},
\code{\link{patternOrder}()},
\code{\link{playMod}()},
\code{\link{playingtable}()},
\code{\link{read.module}()},
\code{\link{trackerFlag}()},
\code{\link{write.module}()}

Other raw.operations: 
\code{\link{as.raw}()},
\code{\link{nybbleToSignedInt}()},
\code{\link{nybble}()},
\code{\link{rawToCharNull}()},
\code{\link{rawToSignedInt}()},
\code{\link{rawToUnsignedInt}()},
\code{\link{signedIntToNybble}()},
\code{\link{signedIntToRaw}()},
\code{\link{unsignedIntToRaw}()}
}
\author{
Pepijn de Vries
}
\concept{module.operations}
\concept{raw.operations}
