% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenerateEntryWiseFigures.R
\name{GenerateEntryWiseFigures}
\alias{GenerateEntryWiseFigures}
\title{Generate Entry Wise Figures}
\usage{
GenerateEntryWiseFigures(
  input_folder = NULL,
  EntryWise = NULL,
  prefix = NULL,
  all_numswitch_plots = FALSE,
  list_of_numswitch_to_plot = NULL
)
}
\arguments{
\item{input_folder}{Input folder. The location of the files created by PreprocessMatrix
if you specified an output_folder. This is also where the num switch array was saved. 
Must specify an input_folder OR EntryWise object. Default: NULL}

\item{EntryWise}{Object where the ComputeEntryWisePerturbationExpectation output was saved.}

\item{prefix}{Prefix of output files, if you so choose.}

\item{all_numswitch_plots}{set to TRUE if you ant to plot all num switch plots 
(potentially very large). Default: FALSE}

\item{list_of_numswitch_to_plot}{List of entries you want visualized with num switch. 
Should be a list of vectors. Example: list(c(0, 0), c(0, 1))}
}
\value{
plot or plots
}
\description{
This function plots the number of mis-predictions versus perturbation
value, overlaid with distribution over stable perturbation values.
Run after ComputeEntryWisePerturbationExpectation()
}
\examples{
\dontrun{
# Set input file
infile <- system.file("extdata", "Modules", "IGP.csv", 
    package = "PressPurt")
# Preprocess the matrix
PreProsMatrix <- PreprocessMatrix(input_file = infile, 
    output_folder = NULL, max_bound = 10, threads = 2)

# Run ComputeEntryWisePerturbationExpectation
Entrywise <- ComputeEntryWisePerturbationExpectation(PreProsMatrix = PreProsMatrix,
    distribution_type = "truncnorm", 
    input_a = 0, input_b = -2, threads = 1)

# Plot specific entries using entrywise object
list_of_numswitch_to_plot <- list(c(1, 1), c(1, 2))
GenerateEntryWiseFigures(EntryWise=Entrywise, 
    all_numswitch_plots = FALSE, 
    list_of_numswitch_to_plot=list_of_numswitch_to_plot)
     

# Plot specific entries from folder
GenerateEntryWiseFigures(input_folder = "test_r/test3", 
    all_numswitch_plots = FALSE, 
    list_of_numswitch_to_plot=list_of_numswitch_to_plot)

# Plot all numswitch plots
GenerateEntryWiseFigures(EntryWise=Entrywise, 
    all_numswitch_plots = TRUE)
}
}
