% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred_results.R
\name{pred_results}
\alias{pred_results}
\title{Predictive Results Wrapper Function}
\usage{
pred_results(
  dataset,
  id = NULL,
  vars,
  type = "group",
  hypothesis,
  gtvar,
  grp_a,
  grp_b,
  location = "median",
  diff_method = "wilcoxon",
  phi_0 = 0.5
)
}
\arguments{
\item{dataset}{A data frame for research.}

\item{id}{The column that identifies unique subjects. This should be \code{NULL}
if \code{type} is 'group' and should not be \code{NULL} if \code{type} is 'prepost'.}

\item{vars}{The column variables of interest.}

\item{type}{The type of study. Valid values are 'group' for group-based data
and 'prepost' for pre-post data. Defaults to 'group'.}

\item{hypothesis}{A vector or string of valid hypotheses: 'increase', 'decrease',
or 'different'.}

\item{gtvar}{The column of interest to divide the groups (e.g., time or treatment).}

\item{grp_a}{The first subset of interest within the \code{gtvar} column
(e.g., 'pre' or 'control').}

\item{grp_b}{The second subset of interest within the \code{gtvar} column
(e.g., 'post' or 'treatment').}

\item{location}{The measure of central tendency to use for the difference
calculation. Valid options are 'median' or 'mean'. Defaults to 'median'.}

\item{diff_method}{The method to use for testing 'different' hypotheses. Valid
options are 'wilcoxon' or 't'. Defaults to 'wilcoxon'.}

\item{phi_0}{The decision rule threshold for the p-value. If p-value < phi_0,
then there's sufficient evidence for a success for a difference. Defaults to 0.50.}
}
\value{
A list containing:
\describe{
\item{results}{A vector of 0s and 1s indicating whether each hypothesis was correct.}
\item{differences}{A vector of the differences between groups.}
\item{variables}{The column variables used in the analysis.}
}
}
\description{
This function is a wrapper that conditionally handles filtering by group or
time, calculates the difference vector, and evaluates hypotheses to return a
list of results.
}
\details{
This function performs error handling to ensure appropriate input values and
types. It then filters the data based on the study type, calculates the difference vector,
and evaluates the hypotheses using the specified method.
}
\examples{
data("group_data_example")
data("group_cog_data")
data("pre_post_data_example")
data("pre_post_fit")

# simple group analysis
pred_results(dataset=group_data_example, vars=c('v1', 'v2'),
hypothesis=c("increase", "different"), gtvar="group", grp_a="placebo", grp_b="drug")

# simple prepost analysis
pred_results(dataset=pre_post_data_example, id="ID", vars=c('v1', 'v2', 'v3'),
type="prepost", hypothesis="increase", gtvar="time", grp_a=0, grp_b=12)

# simulated group analysis
pred_results(dataset=group_cog_data, vars=c('blind_moca_uncorrected', 'craft_verbatim'),
type="group", hypothesis="decrease", gtvar="group.factor", grp_a="Control", grp_b="ESKD")

# simulated prepost analysis
pred_results(dataset=pre_post_fit, id="ID", vars=c('Flex_right', 'Flex_left'),
type="prepost", hypothesis="increase", gtvar="Time", grp_a=0, grp_b=1)
}
