% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixrelations.R
\name{fixrelations}
\alias{fixrelations}
\title{Provide an age structure to relationship status, estimated from age groups}
\usage{
fixrelations(
  people,
  pplid,
  pplage,
  pplstat,
  stfixval,
  props,
  propcol,
  grpdef,
  matchdef,
  userseed = NULL
)
}
\arguments{
\item{people}{A data frame containing individual people.}

\item{pplid}{The variable containing the unique identifier for each person.}

\item{pplage}{The variable containing the ages.}

\item{pplstat}{The relationship status variable in the people data frame.}

\item{stfixval}{The value of the relationship status, in the people data frame, that will be adjusted for age. If there are only two relationship status values, the choice does not matter. But if there are three or more values, this is the one value that will be age-corrected.}

\item{props}{The data frame containing the proportions of people with the stfixval value, by the grpdef.}

\item{propcol}{The variable in the props data frame that contains the proportions for the relationship status value of interest.}

\item{grpdef}{A vector containing the combination of grouping variables, in the people dataframe, that defines the marginal totals for relationship status counts. This can be one variable or a string of multiple variables. Include the age-group variable, but not the age variable.}

\item{matchdef}{A vector containing the same variables as grpdef, except the age variable is substituted for the age-group variable.}

\item{userseed}{If specified, this will set the seed to the number provided. If not, the normal set.seed() function will be used.}
}
\value{
A data frame of observations, with one relationship status redistributed so that an age, rather than age group, structure is created.
}
\description{
Redistributes a user-defined relationship status value between ages, using age groups and other variables (if specified). Within the group definition provided, the marginal totals of the relationship status values are retained.
The data frame can include groups where all people have the same relationship status. In this situation, there is no need to restrict the data frame to only those whose relationship status must be redistributed.
}
\examples{
library("dplyr")
thegroups <- as.vector("Sex")
GroupInfo <- rbind(GroupInfo, list("Male", "Under 20 Years", 19, 19, "Partnered", 0, 19),
                   list("Female", "Under 20 Years", 19, 19, "Partnered", 0, 19))
RelProps <- interdiff(GroupInfo, pplage = "MidPoints", pplprop = "RelProps", endmin = "MinAge",
                      endmax = "MaxAge", grpdef = thegroups)
# add in the age groups
RelProps <- RelProps \%>\%
  mutate(AgeBand = ifelse(Age==19, "Under 20 Years",
                   ifelse(between(Age, 20, 29), "20-29 Years",
                   ifelse(between(Age, 30, 39), "30-39 Years",
                   ifelse(between(Age, 40, 49), "40-49 Years",
                   ifelse(between(Age, 50, 59), "50-59 Years",
                   ifelse(between(Age, 60, 69), "60-69 Years",
                   ifelse(between(Age, 70, 79), "70-79 Years", "80-90 Years"))))))))

# perform separately by sex
thejoindef <- c("Age", "Sex")
thegroups <- c("Sex", "AgeBand")
FinalRels <- fixrelations(BadRels, pplid = "ID", pplage = "Age", pplstat = "Relationship",
                          stfixval = "Partnered", props = RelProps, propcol = "Fits",
                          grpdef = thegroups, matchdef = thejoindef, userseed = 4)
}
