% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hr.R
\name{hrQ}
\alias{hrQ}
\title{Empirical UMP beta centrality quotient}
\usage{
hrQ(w, alpha = 0.05, M = 2, nsim = 1e+05)
}
\arguments{
\item{w}{numeric between 0 and 1}

\item{alpha}{numeric between 0 and 1}

\item{M}{integer sample size greater than 0}

\item{nsim}{integer, the number of simulated null cases generated}
}
\value{
An empirical estimate of the centrality quotient.
}
\description{
Estimates the centrality quotient for the UMP
pooled p-value of a restricted beta family.
}
\details{
The centrality quotient communicates the tendency for a
test to favour evidence shared among all tests over strong
evidence in a single test.

To test the null hypotheses that all p-values are uniform
against a restricted beta family 0 < a <= 1 <= b, the most
powerful pooled p-value linearly combines upper and lower tail
probabilities of the chi-squared distribution with two degrees
of freedom with weights w and (1 - w) where w = (1 - a)/(b - a).

This function uses the individual estimation functions for
central and marginal rejection levels to compute the centrality
quotient for the UMP pooled p-value.
}
\examples{
hrQ(0.8, alpha = 0.05, M = 10)
}
\author{
Chris Salahub
}
