% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PolyHaplotyper.R
\name{usedhap}
\alias{usedhap}
\title{Find all used (inferred) haplotypes}
\usage{
usedhap(hapresults, haploblock)
}
\arguments{
\item{hapresults}{list as returned by inferhaplotypes, or one element
of such a list (i.e. the results for one haploblock)}

\item{haploblock}{if hapresults is one element of the return value of
inferHaplotypes, haploblock should be missing of NULL; else haploblock is
a single value indicating the haploblock: either its name of its index
in hapresults}
}
\value{
an array with the haplotypes that are used in the
population. The haplotypes are in columns, with the haplotype numbers as
colnames; the markers are in rows.
}
\description{
Find all haplotypes for a haploblock that were inferred to be
present in the population (i.e. all haplotypes used for haplotyping any of
the individuals)
}
\details{
This function works with the results of inferHaplotypes; the setting
of dropUnused does not affect this function
}
\examples{
data(PolyHaplotyper_small)
# show the composition of haplotypes inferred to be present
# in the first haploblock:
usedhap(hapresults=phresults, haploblock=1)
}
