% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PolyHaplotyper.R
\name{expandHapdos}
\alias{expandHapdos}
\title{Add dropped rows back to haplotype dosage matrix}
\usage{
expandHapdos(hapdos, nhap, hbname)
}
\arguments{
\item{hapdos}{a haplotype dosage matrix as returned by a.o. inferHaplotypes.
The rownames are assumed to have all the same length:
they are composed of the haploblock name to which the 0-padded haplotype number
is appended, separated by "_"}

\item{nhap}{the total number of haplotypes for the haploblock:
nhap = 2^nmrk with nmrk the number of markers in the haploblock}

\item{hbname}{the haploblock name (only used when hapdos has 0 rows)}
}
\value{
a matrix similar to hapdos with rows for the dropped haplotypes
re-inserted, with the correct rownames and containing only 0 and NA values
}
\description{
Haplotype dosage matrices generated with the dropUnused=TRUE
lack some haplotypes that are required by pedigreeHapCheck; this
function adds them back.
}
\examples{
# specify haplotype dosages of 4 tetraploid individuals,
# only the 3 occurring haplotypes (1, 5 and 6) are given:
haplodosg <- matrix(c(1,2,1, 4,0,0, 0,4,0, 0,0,4), nrow=3,
                   dimnames=list(paste0("demohap_", c(1,5,6)), paste0("indiv", 1:4)))
# add the rows for the absent haplotypes, assuming the haploblock consists
# of 3 markers, so 8 haplotypes are possible:
expandHapdos(hapdos=haplodosg, nhap=8)
}
