% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cppPoD}
\alias{cppPoD}
\title{Probability of disease calculation}
\usage{
cppPoD(titer, pmax, et50, slope, adjustTiters = FALSE, adjustFrom = 0, adjustTo = 0)
}
\arguments{
\item{titer}{numeric vector: vector of subject level titers}

\item{pmax}{numeric: maximum PoD}

\item{et50}{numeric: titer value corresponding to pmax/2 value, PoD(et50) = pmax/2}

\item{slope}{numeric: slope of the PoD curve}

\item{adjustTiters}{boolean: set to TRUE if titer values should be adjusted, for details see \code{PoD} function}

\item{adjustFrom}{numeric: value specifying the detection limit, all values below the detection limit will be adjusted to adjustTo value}

\item{adjustTo}{numeric: value to which titers below the detection limit will be adjusted}
}
\value{
vector of PoDs
}
\description{
Function calculates probability of disease (PoD) for given titers according to a PoD curve.
}
\details{
See \code{PoD} function for more details. These two functions are equivalent. Usage of cppPoD significantly improves the computation speed over the \code{PoD} function.
}
