% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d_hCGF.R
\name{dCGF}
\alias{dCGF}
\alias{d3hCGF}
\alias{d4hCGF}
\alias{l_dhCGF}
\alias{dhCGF1D}
\title{Calculation of derivatives of empirical
cumulant generating function (CGF).}
\usage{
d3hCGF(myt, x)

d4hCGF(myt, x)

l_dhCGF(p)

dhCGF1D(t, x)
}
\arguments{
\item{myt, t}{numeric vector of length \code{p}.}

\item{x}{data matrix.}

\item{p}{Dimension.}
}
\value{
\code{d3hCGF} returns the sequence of third derivatives of
empirical CGF, ordered by index of \eqn{j_1 \leq j_2 \leq j_3 \leq p}.

\code{d4hCGF} returns the sequence of fourth derivatives of empirical
CGF ordered by index of \eqn{j_1 \leq j_2 \leq j_3 \leq j_4 \leq p}.

\code{l_dhCGF} returns number of distinct third and
fourth derivatives.

\code{dhCGF1D} returns third/fourth derivatives of univariate
empirical CGF, which are \code{d3hCGF} and \code{d4hCGF} when \eqn{p = 1}.
}
\description{
Get the third/fortth derivatives of sample CGF at a given point.
}
\details{
Estimator of standardized cumulant function is
\deqn{ \log\hat{M}_X(t) = \log \left(\dfrac{1}{n}
\sum_{i = 1}^n \exp(t'S^{\frac{-1}{2}}(X_i - \bar{X})) \right)
}
and its \deqn{k^{th}} order derivatives is defined as
\deqn{
T_k(t) = \dfrac{\partial^k}{
\partial t_{j_1}t_{j_2} \dots t_{j_k}} \log(\hat{M}_X(t)), t \in \mathbb{R}^p
 }
where \eqn{t_{j_1}t_{j_2} \dots t_{j_k}} are the corresponding components
of vector \eqn{t \in \mathbb{R}^p}.
}
\examples{
p <- 3
# Number of distinct derivatives
l_dhCGF(p)
set.seed(1)
x <- MASS::mvrnorm(100, rep(0, p), diag(p))
myt <- rep(.2, p)
d3hCGF(myt = myt, x = x)
d4hCGF(myt = myt, x = x)
#Univariate data
set.seed(1)
x <- rnorm(100)
t <- .3
dhCGF1D(t, x)
}
