% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covZtZs.R
\name{covZtZs}
\alias{covZtZs}
\alias{mt3_covZtZs}
\alias{mt4_covZtZs}
\title{Covariance matrix of derivatives of sample moment
generating function (MGF).}
\usage{
mt3_covZtZs(t, s, pos.matrix = NULL)

mt4_covZtZs(t, s, pos.matrix = NULL)
}
\arguments{
\item{t, s}{a vector of length \eqn{p}.}

\item{pos.matrix}{matrix contains information of positions of derivatives.
Default is \code{NULL}, where the function will call
\code{\link[=mt3_pos]{mt3_pos()}} or \code{\link[=mt4_pos]{mt4_pos()}}.}
}
\value{
\code{mt3_covZtZs} Covariance matrix relating to the use
of third derivatives.

\code{mt4_covZtZs} Covariance matrix relating to the use of
fourth derivatives. This also contains information on the third
third derivatives \code{mt3_covZtZs}.
}
\description{
Stacking derivatives upto the third/fourth orders of sample MGF
together to obtain a vector, which (under normality assumption) approaches
a multivariate normally distributed vector
with zero mean and a covariance matrix.
\code{covZtZs} calculates covariance between any two points
\eqn{t} and \eqn{s} in \eqn{\mathbb{R}^p}.
}
\examples{
set.seed(1)
p <- 3
x <- MASS::mvrnorm(100, rep(0, p), diag(p))
t <- rep(0.2, p)
s <- rep(-.3, p)
# Using third derivatives
pos.matrix3 <- mt3_pos(p)
sZtZs3 <- mt3_covZtZs(t, s, pos.matrix = pos.matrix3)
dim(sZtZs3)
sZtZs3[1:5, 1:5]
# Using fourth derivatives
sZtZs4 <- mt4_covZtZs(t, s)
dim(sZtZs4)
sZtZs4[1:5, 1:5]
}
