% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DPH_functions.R
\name{DPH_functions}
\alias{DPH_functions}
\alias{dDPH}
\alias{qDPH}
\alias{pDPH}
\alias{rDPH}
\alias{rFullDPH}
\title{The Univariate Discrete Phase-Type Distribution}
\usage{
dDPH(x, obj)

qDPH(p, obj)

pDPH(q, obj)

rDPH(n, obj)

rFullDPH(obj)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{obj}{an object of class \code{disc_phase_type}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If length(n) > 1, the length is taken to be
the number required.}
}
\value{
\code{dDPH} gives the density, \code{pDPH} gives the
distribution function, \code{qDPH} gives the quantile function,
and \code{rDPH} generates random deviates. \code{rFullDPH} returns
the full path of a random draw from the distribution.

The length of the result is determined by \code{n} for \code{rDPH},
and is the maximum of the lengths of the numerical arguments for the other
functions.

The numerical arguments other than \code{n} are recycled to the length of the
result. Only the first elements of the logical arguments are used.
}
\description{
Density, distribution function, quantile function and random generation
for the univariate discrete phase-type distribution.
}
\section{Functions}{
\itemize{
\item \code{dDPH}: Density function for the univariate continuous phase-type distribution.

\item \code{qDPH}: Quantile function for the univariate discrete phase-type distribution.

\item \code{pDPH}: Distribution function for the univariate discrete phase-type distribution.

\item \code{rDPH}: Random number generator for the univariate discrete phase-type distribution.

\item \code{rFullDPH}: Simulation of the full path for the univariate discrete phase-type distribution.
}}

\examples{


disc_phase_type <- matrix(c(0.4, 0, 0.2,
                            0.5, 0.3, 0.2,
                            0, 0.7, 0.2), ncol = 3)
Y <- DPH(disc_phase_type)

dDPH(3:4, Y)
pDPH(5, Y)
qDPH(0.5, Y)
set.seed(0)
rDPH(6, Y)
rFullDPH(Y)

}
\seealso{
\link[stats]{Distributions} for other standard distributions.
}
