% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{RunAdaptiveEffToxTrialCORRCONTOUR}
\alias{RunAdaptiveEffToxTrialCORRCONTOUR}
\title{Simulates desirability based Efftox trials}
\usage{
RunAdaptiveEffToxTrialCORRCONTOUR(
  DoseStart,
  Dose,
  Hypermeans,
  Hypervars,
  Contour,
  PiLim,
  ProbLim,
  cohort,
  NET,
  NF,
  B,
  nSims,
  PMAT
)
}
\arguments{
\item{DoseStart}{Dose level to START the EFF-Tox Trial}

\item{Dose}{Vector of Doses considered in the trial}

\item{Hypermeans}{6 vector of prior means}

\item{Hypervars}{6 vector of prior standard deviations}

\item{Contour}{4 vector used to specify the tradeoff contour.}

\item{PiLim}{2 vector of acceptable limits}

\item{ProbLim}{2 vector of cutoff for acceptabilities}

\item{cohort}{Cohort size}

\item{NET}{Maximum Sample size to run the EFFtox Trial, must be divisible by cohort}

\item{NF}{Minimum sample size to begin adaptive randomization, must be divisible by count}

\item{B}{Number of reps to perform in MCMC}

\item{nSims}{Number of Simulated trials to run.}

\item{PMAT}{Contains TRUE pi00,pi10, pi01, pi11 for each dose}
}
\value{
Trial simulation results to be processed for operating characteristics summaries.
}
\description{
Simulates Efftox trials based on the desirability tradeoff contour.
}
