% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_modification.R
\name{obtain_mod_MSFragger}
\alias{obtain_mod_MSFragger}
\title{Obtain modification information from Peptide data generated by MSFragger}
\usage{
obtain_mod_MSFragger(
  data,
  mod_column,
  seq_column,
  PTM_table = NULL,
  PTM_annotation = FALSE,
  PTM_mass_column
)
}
\arguments{
\item{data}{A data.table with a column containing stripped sequence and a column containing PTM information.}

\item{mod_column}{The name of the column containing the modified peptide sequences.}

\item{seq_column}{The name of the column containing peptide sequences for MSFragger.}

\item{PTM_table}{A data.table with columns 'PTM_mass' and 'PTM_type' containing PTM annotation information.}

\item{PTM_annotation}{A logical value indicating whether to include PTM annotation information in the result.}

\item{PTM_mass_column}{The name of the column containing the PTM mass information}
}
\value{
A data.table with 'PTM_position', 'PTM_type', 'reps', and other columns.
}
\description{
This function takes MSFragger output containing a 'Assigned Modifications' column with
PTM information and converts it into a new dataframe with the desired format of peptide
sequences and associated PTM information.
}
\examples{
library(data.table)
data <- data.table(
  Peptide = c("DDREDMLVYQAK", "EAAENSLVAYK", "IEAELQDICNDVLELLDK"),
  `Assigned Modifications` = c("C-term(15.9949), 6M(-0.98)", "", "N-term(42.0106)"),
  Condition1 = c("A", "B", "B"),
  Condition2 = c("C", "C", "D")
)
PTM_table <- data.table(
  PTM_mass = c(42.0106, -0.98, 15.9949),
  PTM_type = c("Acet", "Amid", "Ox")
)
mod_column <- "Assigned Modifications"
seq_column <- "Peptide"
converted_data <- obtain_mod_MSFragger(
  data,
  mod_column,
  seq_column,
  PTM_table,
  PTM_annotation = TRUE,
  PTM_mass_column = "PTM_mass"
)

}
