% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_modification.R
\name{obtain_mod}
\alias{obtain_mod}
\title{Obtain post translational modification(PTM) information from Peptide data
based on the specified data type}
\usage{
obtain_mod(
  data,
  mod_column,
  type,
  seq_column = NULL,
  PTM_table = NULL,
  PTM_annotation = FALSE,
  PTM_mass_column
)
}
\arguments{
\item{data}{A data frame with the peptide sequences.}

\item{mod_column}{The name of the column containing the modified peptide sequences.}

\item{type}{A character string specifying the data type (e.g. 'Skyline' or 'Maxquant').}

\item{seq_column}{(Optional) The name of the column containing peptide sequences for MSFragger, mzid and mzTab.
This parameter is required for the "MSFragger", "mzIdenML" and "mzTab" type and can be omitted
for other types.}

\item{PTM_table}{A data frame with columns 'PTM_mass' and 'PTM_type' containing PTM annotation information.}

\item{PTM_annotation}{A logical value indicating whether to include PTM annotation information in the result.}

\item{PTM_mass_column}{The name of the column containing the PTM mass information.}
}
\value{
A data.table with 'PTM_position', 'PTM_type', 'PTM_mass', 'reps', and other columns.
}
\description{
This function takes outputs from multiple platform, a data frame with column
containing modified peptide sequence with the detailed post translational
modification(PTM) information and converts it into a new dataframe with the desired format of peptide
sequences and associated PTM information. Due to the flexibility of outputs from
multiple platform, the PTM mass to type table needs to be provided if convertion to PTM_type is needed.
The result includes 'Peptide', 'PTM_position', 'PTM_type' and 'PTM_mass' columns.The function chooses
the appropriate converting method based on the specified data type ('PEAKS',
'Spectronaut', 'MSFragger', 'Comet', 'DIANN', 'Skyline', 'Maxquant', 'mzIdenML' or 'mzTab'),
allowing you to convert the data into a consistent format for further analysis.
}
\examples{
library(data.table)
data_skyline <- data.table(
  'Peptide Modified Sequence' = c(
    "AGLC[+57]QTFVYGGC[+57]R",
    "AAAASAAEAGIATTGTEDSDDALLK",
    "IVGGWEC[+57]EK"
  ),
  Condition = c("A", "B", "B")
)
PTM_table <- data.table(
  PTM_mass = c(57.02, -0.98, 15.9949),
  PTM_type = c("Cam", "Amid", "Ox")
)
converted_data_skyline <- obtain_mod(
  data_skyline,
  'Peptide Modified Sequence',
  'Skyline',
  seq_column = NULL,
  PTM_table,
  PTM_annotation = TRUE,
  PTM_mass_column = "PTM_mass"
)

data_maxquant <- data.table(
  'Modified sequence' = c(
    "_(ac)AAAAELRLLEK_",
    "_EAAENSLVAYK_",
    "_AADTIGYPVM(ox)IRSAYALGGLGSGICPNK_"
  ),
  Condition = c("A", "B", "B")
)
PTM_table <- data.table(
  PTM_mass = c('Phospho (STY)', 'Oxidation (M)'),
  PTM_type = c("Phos", "Ox")
)
converted_data_maxquant <- obtain_mod(
  data_maxquant,
  'Modified sequence',
  'Maxquant',
  seq_column = NULL,
  PTM_table,
  PTM_annotation = TRUE,
  PTM_mass_column = "PTM_mass"
)


}
