% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global.R
\name{plotF}
\alias{plotF}
\title{Plot functions for the F matrices.}
\usage{
plotF(x, choice = "Fshape", nround = 2, pixmap.color = terrain.colors(20))
}
\arguments{
\item{x}{The F matrix.}

\item{choice}{A string: either "F", "Fpixmap", "Fshape", or "Fshapepixmap"}

\item{nround}{An integer. For numerical F matrices only. The number of
decimal numbers to display.}

\item{pixmap.color}{For pixmap plots.}
}
\value{
Nothing.
}
\description{
The graphical output will differ according to the option used.
}
\examples{

#For numerical/inferred F matrices
plotF(CascadeFinit(4,4),choice="F", nround=1)

if (requireNamespace("pixmap", quietly = TRUE)) {
plotF(CascadeFinit(4,4),choice="Fpixmap")
} else {
plotF(CascadeFinit(4,4),choice="F", nround=1)
}

#For theoritical F matrices
plotF(CascadeFshape(4,4),choice="Fshape")
if (requireNamespace("pixmap", quietly = TRUE)) {
plotF(CascadeFshape(4,4),choice="Fshapepixmap")
} else {
plotF(CascadeFshape(4,4),choice="Fshape")
}

}
\author{
Bertrand Frederic, Myriam Maumy-Bertrand.
}
\keyword{dplot}
