% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pspaceMethods.R
\docType{methods}
\name{silhouetteMapping,PathwaySpace-method}
\alias{silhouetteMapping,PathwaySpace-method}
\alias{silhouetteMapping}
\title{Decorating PathwaySpace Images with Graph Silhouettes}
\usage{
\S4method{silhouetteMapping}{PathwaySpace}(
  ps,
  pdist = 0.05,
  baseline = 0.01,
  fill.cavity = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{ps}{A \linkS4class{PathwaySpace} class object.}

\item{pdist}{A term (in \code{[0,1]}) determining a distance unit for the
silhouette projection.}

\item{baseline}{A fraction (in \code{[0,1]}) of the silhouette projection,
representing the level over which a silhouette will outline the graph layout.
When \code{baseline = 0} (i.e. lower level of the projection), the 
silhouette will extend over the entire image space, so no outline will 
be visible.}

\item{fill.cavity}{A logical value specifying to fill cavities 
in the silhouette mask (when \code{verbose=TRUE}) or not 
(when \code{verbose=FALSE}).}

\item{verbose}{A logical value specifying to display detailed 
messages (when \code{verbose=TRUE}) or not (when \code{verbose=FALSE}).}
}
\value{
A preprocessed \linkS4class{PathwaySpace} class object.
}
\description{
\code{silhouetteMapping} constructs an image baseline used
to outline the graph layout in a PathwaySpace image.
}
\examples{
# Load a demo igraph
data('gtoy1', package = 'RGraphSpace')

# Create a new PathwaySpace object
ps <- buildPathwaySpace(gtoy1, nrc = 100)
# note: adjust 'nrc' to increase image resolution

# Set '1s' as vertex signal
vertexSignal(ps) <- 1

# Map graph silhouette
ps <- silhouetteMapping(ps, pdist = 0.1)

}
\seealso{
\code{\link{circularProjection}}
}
\author{
Sysbiolab Team
}
