% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{Pareto_Layer_SM}
\alias{Pareto_Layer_SM}
\title{Second Layer Moment of the Pareto Distribution}
\usage{
Pareto_Layer_SM(Cover, AttachmentPoint, alpha, t = NULL, truncation = NULL)
}
\arguments{
\item{Cover}{Numeric. Cover of the reinsurance layer. Use \code{Inf} for unlimited layers.}

\item{AttachmentPoint}{Numeric. Attachment point of the reinsurance layer.}

\item{alpha}{Numeric. Pareto alpha.}

\item{t}{Numeric. Threshold of the Pareto distribution. If \code{t} is \code{NULL} (default) then \code{t <- Attachment Point} is used}

\item{truncation}{Numeric. If \code{truncation} is not \code{NULL} and \code{truncation > t}, then the Pareto distribution is truncated at \code{truncation}.}
}
\value{
The second moment of the (truncated) Pareto distribution with parameters \code{t} and \code{alpha} in the layer
        \code{Cover} xs \code{AttachmentPoint}
}
\description{
Calculates the second moment of a Pareto distribution in a reinsurance layer
}
\examples{
Pareto_Layer_SM(4000, 1000, 2)
Pareto_Layer_SM(4000, 1000, alpha = 2, t = 1000)
Pareto_Layer_SM(4000, 1000, alpha = 2, t = 5000)
Pareto_Layer_SM(4000, 1000, alpha = 2, t = 1000, truncation = 5000)
Pareto_Layer_SM(9000, 1000, alpha = 2, t = 1000, truncation = 5000)

}
