% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lewicki2MSI.R
\name{Lewicki2MSI}
\alias{Lewicki2MSI}
\title{Lewicki-2-Parameter Moisture Sorption Isotherm}
\usage{
Lewicki2MSI(WaterAct, AdsorpM, DesorpM)
}
\arguments{
\item{WaterAct}{the numerical value of Water Activity, which ranges from 0 to 1.}

\item{AdsorpM}{the numerical value of the Moisture content of the Adsorption curve, which ranges from 0 to 1.}

\item{DesorpM}{the numerical value of the Moisture content of the Desorption curve, which ranges from 0 to 1.}
}
\value{
the nonlinear regression, parameters, and graphical visualization for Lewicki-2-Parameter model.
}
\description{
Lewicki-2-Parameter MSI is a two-parameter sorption model that was developed based on Raoult's law, which assumes that water is present either as free water or as water of hydration.
}
\examples{
WaterAct <- c(0.1145,0.2274,0.3265,0.4291,0.6342,0.7385,0.8274,0.9573)
AdsorpM <- c(0.0234, 0.0366, 0.0496, 0.0648, 0.0887, 0.1096, 0.1343, 0.1938)
DesorpM <- c(0.0459, 0.0637, 0.0794, 0.0884, 0.1158, 0.1298,0.1500, 0.1938)
Lewicki2MSI(WaterAct, AdsorpM, DesorpM)
}
\references{
Lewicki, P. P. (2000) <doi:10.1016/S0260-8774(99)00130-2> Raoult's law based food water sorption isotherm. Journal of Food Engineering, 43(1), 31-40.
}
\author{
Benz L. Rivera

John Carlo F. Panganiban

Kim M. Villacorte

Chester C. Deocaris
}
