% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KuhnMSI.R
\name{KuhnMSI}
\alias{KuhnMSI}
\title{Kuhn Moisture Sorption Isotherm}
\usage{
KuhnMSI(WaterAct, AdsorpM, DesorpM)
}
\arguments{
\item{WaterAct}{the numerical value of Water Activity, which ranges from 0 to 1.}

\item{AdsorpM}{the numerical value of the Moisture content of the Adsorption curve, which ranges from 0 to 1.}

\item{DesorpM}{the numerical value of the Moisture content of the Desorption curve, which ranges from 0 to 1.}
}
\value{
the nonlinear regression, parameters, and graphical visualization for the Kuhn Moisture Sorption Isotherm model.
}
\description{
Kuhn Isotherm is a two-parameter model which contains many defining characteristics wherein each surface site has a different adsorption potential, as well as cluster formations on each site due to increase in partial pressure.
}
\examples{
WaterAct <- c(0.1145,0.2274,0.3265,0.4291,0.6342,0.7385,0.8274,0.9573)
AdsorpM <- c(0.0234, 0.0366, 0.0496, 0.0648, 0.0887, 0.1096, 0.1343, 0.1938)
DesorpM <- c(0.0459, 0.0637, 0.0794, 0.0884, 0.1158, 0.1298,0.1500, 0.1938)
KuhnMSI(WaterAct, AdsorpM, DesorpM)
}
\references{
Bi, Y., et al. (2018). The prediction of moisture adsorption isotherm for commercial sodium bicarbonate powder. International Journal of Scientific & Engineering Research, 9(3).

Kuhn, I. (1967) <doi:10.1016/0021-9797(67)90202-0> A generalized potential theory of adsorption. I. The derivation of a general equation for adsorption isotherms. Journal of Colloid And Interface Science, 23(4), 563-571.
}
\author{
Benz L. Rivera

John Carlo F. Panganiban

Kim M. Villacorte

Chester C. Deocaris
}
