% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{plot_target}
\alias{plot_target}
\title{Plot the surface of the target function for nonlinear least squares estimation}
\usage{
plot_target(
  obj,
  im = 1,
  iq = NULL,
  par = NULL,
  basedon = c(1, 2),
  from,
  to,
  length.out = 40
)
}
\arguments{
\item{obj}{An object of class \code{"PSTR"}.}

\item{im}{Integer. The number of switches \eqn{m} in the transition function used to
construct the target function surface. Default is \code{1}.}

\item{iq}{Either an integer index (a column number in the transition-variable matrix)
or a character string (a transition-variable name) specifying which transition variable
is used when computing the target function.}

\item{par}{Numeric vector of length \code{1 + im} giving fixed values of the nonlinear
parameters in the order \code{c(delta, c_1, ..., c_m)}. If \code{NULL}, the function
constructs a default initial vector from quantiles of the chosen transition variable.}

\item{basedon}{Integer vector of length \code{2}. Positions in \code{par} indicating the
two parameters to vary on the grid. The values at these positions in \code{par} are
ignored and replaced by grid values.
Use \code{1} for \eqn{\delta}, and \code{2:(im+1)} for \eqn{c_1, \ldots, c_m}.}

\item{from}{Numeric vector of length \code{2}. Lower bounds (start values) for the two
grid parameters specified by \code{basedon}.}

\item{to}{Numeric vector of length \code{2}. Upper bounds (end values) for the two
grid parameters specified by \code{basedon}.}

\item{length.out}{Either a scalar or a numeric vector of length \code{2}. If scalar, the
same number of grid points is used for both dimensions. If length 2, the first element
controls the grid resolution for the first parameter in \code{basedon}, and the second
for the second parameter.}
}
\value{
A \code{plotly} object representing a 3-D surface plot of the target function
  values evaluated on the specified parameter grid.
}
\description{
This function plots a 3-D surface of the nonlinear least squares (NLS) target function
used in estimating a PSTR model. It is mainly intended as a diagnostic tool for choosing
reasonable initial values for the nonlinear parameters.
}
\details{
The target function is evaluated on a two-dimensional grid over two selected parameters,
while all other nonlinear parameters are held fixed at values provided by \code{par}.
The nonlinear parameter vector is always ordered as
\eqn{\delta, c_1, \ldots, c_m}, where \eqn{\gamma = \exp(\delta)} and \eqn{m = im}.

In addition to the exported function \code{plot_target(obj = ...)}, the same functionality
is available as an R6 method via \code{obj$plot_target(...)}.
}
\examples{
\donttest{
pstr <- NewPSTR(Hansen99, dep = "inva", indep = 4:20,
               indep_k = c("vala", "debta", "cfa", "sales"),
               tvars = c("vala"), iT = 14)

# 1) Exported function interface
ret <- plot_target(obj = pstr, iq = 1, basedon = c(1, 2),
                   from = c(log(1), 6), to = c(log(18), 10),
                   length.out = c(40, 40))

# 2) R6 method interface
ret2 <- pstr$plot_target(iq = 1, basedon = c(1, 2),
                         from = c(log(1), 6), to = c(log(18), 10),
                         length.out = c(40, 40))
}

}
\seealso{
\code{\link{NewPSTR}}, \code{\link{LinTest}}, \code{\link{WCB_LinTest}},
  \code{\link{EstPSTR}}, \code{\link{EvalTest}}, \code{\link{WCB_TVTest}},
  \code{\link{WCB_HETest}}
}
