% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PSTR.R
\docType{package}
\name{PSTR-package}
\alias{PSTR}
\alias{PSTR-package}
\title{PSTR: A package implementing the Panel Smooth Transition Regression (PSTR) modelling.}
\description{
The package implements the Panel Smooth Transition Regression (PSTR) modelling.
}
\details{
The modelling procedure consists of three stages: Specification, Estimation and Evaluation.
The package offers tools helping the package users to conduct model specification tests,
to do PSTR model estimation, and to do model evaluation.

The cluster-dependency and heteroskedasticity-consistent tests are implemented in the package.

The wild bootstrap and cluster wild bootstrap tests are also implemented.

Parallel computation (as an option) is implemented in some functions, especially the bootstrap tests.
Therefore, the package suits tasks running many cores on super-computation servers.

The Panel Smooth Transition Regression (PSTR) model is defined to be
\deqn{y_{it} = \mu_i + \beta_0' x_{it} + \beta_1' z_{it} g_{it} + u_{it}}
where \eqn{g_{it}} is the transition function taking the logistic form with the transition variable for individual \eqn{i}, \eqn{x_{it}} contains the explanatory variables in the linear part, and \eqn{z_{it}} contains the explanatory variables in the nonlinear part, and they can be different.

The transition function \eqn{g_{it}} takes the logistic form
\deqn{g(q_{it} ; \gamma, c) = \left( 1 + \exp \left( - \gamma \prod_{j=1}^{m} (q_{it} - c_j) \right) \right)^{-1}}
with \eqn{\gamma > 0} and \eqn{c_1 < c_2 < ... < c_m}. \eqn{\gamma} can be reparametrized as \eqn{\gamma = \exp{\delta}} where \eqn{\delta} is a real number.
}
\section{Author and Maintainer}{

Yukai Yang

Department of Statistics, Uppsala University

\email{yukai.yang@statistik.uu.se}
}

\section{References}{

González, A., Teräsvirta, T., van Dijk, D. and Yang, Y. (2005) "\href{http://swopec.hhs.se/hastef/papers/hastef0604.pdf}{Panel Smooth Transition Regression Models}", SSE/EFI Working Paper Series in Economics and Finance 604, Stockholm School of Economics, revised 11 Oct 2017.
}

\section{Function for Initialization}{

\code{\link{NewPSTR}} initialize the modelling by creating an object of the class PSTR.
}

\section{Functions for Model Specification}{

\code{\link{LinTest}} implements the linearity tests.

\code{\link{WCB_LinTest}} implements the wild bootstrap (WB) and the wild cluster bootstrap (WCB) linearity tests.
}

\section{Function for Model Estimation}{

\code{\link{EstPSTR}} implements the estimation of the PSTR model.
}

\section{Functions for Model Evaluation}{

\code{\link{EvalTest}} implements the evaluation tests.

\code{\link{WCB_TVTest}} implements the wild bootstrap (WB) and the wild cluster bootstrap (WCB) evaluation test of no time-varying parameters.

\code{\link{WCB_HETest}} implements the wild bootstrap (WB) and the wild cluster bootstrap (WCB) evaluation test of no remaining nonlinearity (no remaining heterogeneity).
}

\section{Other Functions}{

\code{\link{version}} shows the version number and some information of the package.

\code{\link{print.PSTR}} prints the object of the class PSTR.

\code{\link{plot_transition}} plots the transition function of an estimated PSTR model.

\code{\link{plot_coefficients}} plots coefficients, standard errors, and p-values against the transition variable.

\code{\link{plot_response}} plots curve or surfaces of the expected reponse agaist the corresponding variable.

\code{\link{plot_target}} plots the surface of the target function for the nonlinear least square estimation.
}

\section{Data}{

\code{\link{Hansen99}} a balanced panel of 565 US firms observed for the years 1973–1987.

\code{\link{sunspot}} transformed Wolf annual sunspot numbers for the years 1710-1979.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/yukai-yang/PSTR}
  \item Report bugs at \url{https://github.com/yukai-yang/PSTR/issues}
}

}
\author{
\strong{Maintainer}: Yukai Yang \email{yukai.yang@statistik.uu.se} (\href{https://orcid.org/0000-0002-2623-8549}{ORCID})

}
\keyword{internal}
