% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RPM-PSSM.R
\name{RPM_PSSM}
\alias{RPM_PSSM}
\title{RPM-PSSM feature vector}
\usage{
RPM_PSSM(pssm_name)
}
\arguments{
\item{pssm_name}{name of PSSM Matrix file}
}
\value{
RPM-PSSM feature vector of length 400
}
\description{
In this feature The idea is similar to the probe concept used in microarray technologies, where probes are used to identify
genes. For the convenience, we call it residue probing method. In our application, each probe is an amino acid, which
corresponds to a particular column in the PSSM profiles. For each probe, we average the PSSM scores of all the amino acids
in the associated column with a PSSM value greater than zero in the sequence, which leads to a 1  20 feature vector. Once
again, for the 20 probes, the final feature for each protein sequence is a 1  400 vector.
}
\examples{
X<- RPM_PSSM(system.file("extdata","C7GRQ3.txt.pssm",package="PSSMCOOL"))
}
\references{
Jeong, J.C., Lin, X. and Chen, X.W. (2011) On position-specific scoring matrix for protein function prediction
, IEEE/ACM transactions on computational biology and bioinformatics / IEEE, ACM, 8, 308-315.
}
