% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_prp.R
\name{posterior_prp}
\alias{posterior_prp}
\title{Posterior Predictive Replication p-value Calculation}
\usage{
posterior_prp(
  beta,
  se,
  L = 1000,
  r_vec = c(0, 8e-04, 0.006, 0.024),
  test = Q,
  print_test_dist = FALSE
)
}
\arguments{
\item{beta}{A vector, containing the estimates in the original study and the
replication study.}

\item{se}{A vector, containing the standard errors of the estimates in the original
study and the replication study.}

\item{L}{A value, determining the times of repeating simulation.}

\item{r_vec}{A vector, defining the prior reproducible model. Each r value
corresponds to a probability of sign consistency.}

\item{test}{A function designed to calculate the test quantity, the default
one is the Cochran's Q test statistics.}

\item{print_test_dist}{A boolean, determining whether the simulated test statistics
value difference will be plot as a histogram or not. Default is False.}
}
\value{
A list with the following components:
\item{grid}{ Detailed grid values for the hyperparameters.}
\item{test_statistics}{ The test statistics used in calculating the replication p-value.}
\item{n_sim}{ The L value.}
\item{test_stats_dif}{ The difference between the simulated test statistics
quantity and the original value.}
\item{pvalue}{ The resulting posterior predictive replicaiton p-value.}
}
\description{
Posterior Predictive Replication p-value Calculation
}
\examples{
data("mortality")
res = posterior_prp(beta = mortality$beta, se = mortality$se, test=Q)
names(res)
print(res$pvalue)

}
