% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processArgs.R
\name{processArgs}
\alias{processArgs}
\alias{chkstop_df}
\alias{chkstop_okmiss}
\alias{chkstop_type}
\alias{chkstop_revitems}
\alias{chk_imin}
\alias{chk_imax}
\alias{chkstop_minmax}
\title{Argument Processors for \code{\link{scoreScale}} Function}
\usage{
chkstop_df(df)

chkstop_okmiss(okmiss)

chkstop_type(type, minmax)

chkstop_revitems(df, dfItems, revitems, items, minmax)

chk_imin(dfItems, imin)

chk_imax(dfItems, imax)

chkstop_minmax(dfItems, minmax)
}
\arguments{
\item{df}{A data frame, such as the one given \code{\link{scoreScale}}}

\item{okmiss}{Proportion of missing items allows, given as argument to
\code{\link{scoreScale}}}

\item{type}{Score type, given as argument to \code{\link{scoreScale}}}

\item{minmax}{Minimum and maximum possible item values, given as argument to
\code{\link{scoreScale}}}

\item{dfItems}{A data frame with only items, created and used by
\code{\link{scoreScale}} as an interim step in scoring a scale}

\item{revitems}{Items to reverse, given as argument to \code{\link{scoreScale}}}

\item{items}{Item index, given as argument to \code{\link{scoreScale}}}

\item{imin}{Minimum possible item value}

\item{imax}{Maximum possible item value}
}
\value{
Functions with prefix \code{chk_} return \code{TRUE} if the argument
is OK, or \code{FALSE} if the argument fails the check. Functions with the
prefix \code{chkstop_} print an error message and stop the execution of the
function in which they are embedded.
}
\description{
Functions that are used internally within other
\code{\link{PROscorerTools}} functions, namely \code{\link{scoreScale}}, to
process the arguments passed to them.  Only developers wishing to
contribute to the \code{\link{PROscorerTools}} package should use these
functions. Even developers should avoid using them for anything but
experimentation.  If you use these functions, be warned that they will
likely change in future versions of the package in ways that may not be
compatible with your usage. They will also be made invisible to users in
future version of the \code{\link{PROscorerTools}} package.  The only
reason they are visible to users in these initial versions of the package
is to make the internals of the package more transparent to potential
developers to facilitate the development and improvement of the package.
}
\details{
Functions with prefix \code{chk_} simply check the argument and
return \code{TRUE} if the argument is OK, or \code{FALSE} if the argument
fails the check.  Functions with the prefix \code{chkstop_} check the
argument and, if \code{FALSE}, stop execution and display an error message
to help the user pinpoint the problem.
}
\keyword{internal}
