% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{optim_est}
\alias{optim_est}
\title{Gradient descent for obtaining estimator}
\usage{
optim_est(
  X_lab,
  X_unlab,
  Y_lab,
  Yhat_lab,
  Yhat_unlab,
  w,
  theta,
  quant = NA,
  method,
  step_size = 0.1,
  max_iterations = 500,
  convergence_threshold = 1e-06
)
}
\arguments{
\item{X_lab}{Array or DataFrame containing observed covariates in labeled data.}

\item{X_unlab}{Array or DataFrame containing observed or predicted covariates in unlabeled data.}

\item{Y_lab}{Array or DataFrame of observed outcomes in labeled data.}

\item{Yhat_lab}{Array or DataFrame of predicted outcomes in labeled data.}

\item{Yhat_unlab}{Array or DataFrame of predicted outcomes in unlabeled data.}

\item{w}{weights vector POP-Inf linear regression (d-dimensional, where d equals the number of covariates).}

\item{theta}{parameter theta}

\item{quant}{quantile for quantile estimation}

\item{method}{indicates the method to be used for M-estimation. Options include "mean", "quantile", "ols", "logistic", and "poisson".}

\item{step_size}{step size for gradient descent}

\item{max_iterations}{maximum of iterations for gradient descent}

\item{convergence_threshold}{convergence threshold for gradient descent}
}
\value{
estimator
}
\description{
\code{optim_est} function for gradient descent for obtaining estimator
}
